<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.EligibilityType' %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="phEligibilityCode"><%=EligibilityType.PURPLE_HEART_RECIPIENT.getName()%></c:set>
<c:set var="editEligibility"><%=Capability.EDIT_ELIGIBILITY.getName()%></c:set>
<c:set var="editPH"><%=Capability.EDIT_PURPLE_HEART_INFO.getName()%></c:set>
<c:set var="viewPH"><%=Capability.VIEW_PURPLE_HEART_INFO.getName()%></c:set>
<c:set var="logPH"><%=Capability.LOG_PURPLE_HEART_DOC.getName()%></c:set>
<c:set var="viewCD"><%=Capability.VIEW_PERSON_CLINICAL_DETERMINATION.getName()%></c:set>
<c:set var="managePOW"><%=Capability.MANAGE_POW%></c:set>
<c:set var="viewPOW" value="false"/>

<c:set var="vetChoiceStat"><esrcore:displayValue name="eligibilityViewForm" property="vetChoiceStat"/></c:set>

<auth:authorize access="hasAnyRole(${editEligibility})">
  <c:set var="editEligibility" value="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(${viewPH},${logPH},${editPH})">
  <c:set var="editPH" value="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(${managePOW})">
  <c:set var="viewPOW" value="true"/>
</auth:authorize>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="editEligibility" value="false"/>
</c:if>

<%-- Permissions for Health Benefit Plans --%>
<c:set var="viewHealthBenefitsPlans"><%=Capability.VIEW_HEALTH_BENEFITS_PLANS.getName()%></c:set>
<c:set var="assignHealthBenefitsPlans"><%=Capability.ASSIGN_HEALTH_BENEFITS_PLANS.getName()%></c:set>
<c:set var="unAssignHealthBenefitsPlans"><%=Capability.UNASSIGN_HEALTH_BENEFITS_PLANS.getName()%></c:set>
<c:set var="viewHbp" value="false" />
<auth:authorize access="hasAnyRole(${viewHealthBenefitsPlans})">
    <c:set var="viewHbp" value="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(${assignHealthBenefitsPlans})">
    <c:set var="viewHbp" value="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(${unAssignHealthBenefitsPlans})">
    <c:set var="viewHbp" value="true"/>
</auth:authorize>

<script type="text/javascript"> 
	function onLoadInit(){
		
		setTimeout(function(){			
			var editLinkObj = document.getElementsByName("editEligibilityLink");
			
			if(editLinkObj != null){		
				editLinkObj[0].focus(); 
			}
		}, 1000);
	}
</script>


   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap style="padding-left: 7"><bean-el:message key="eligibilityView.eligPanel.title"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            <c:if test="${editEligibility == true}">
            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                <fw:link action="/gotoEligibilityEdit.do?methodName=Edit" linkName="editEligibilityLink">
                    <bean-el:message key="eligibilityView.link.editCurrent"/>
                </fw:link>
            </td>
            </c:if>
            <td width="2%"><img alt=""  src="../images/spacer.gif"></td>
			      <!-- Display purple Heart link only for Veteran -->
            <c:if test="${eligibilityViewForm.veteranIndicator == true && editPH == true}">
            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
              <fw:link action="editPurpleHeart.do?methodName=DISPLAY">
                <bean-el:message key="link.editPurpleHeart"/>
              </fw:link>
            </td>
            </c:if>
            <td width="2%"><img alt=""  src="../images/spacer.gif"></td>
            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
              <fw:link action="/eligibilityHistory?methodName=DISPLAY&amp;history=viewHistoricalEligibility">
                <bean-el:message key="text.viewHistoricalEligibility"/>
              </fw:link>
            </td>
           </tr>
          </table>
         </td>
        </tr>
        <tr>
         <td>
          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
            <tr>
              <td width="25%" class="label"><bean-el:message key="label.primary"/>:</td>
              <td width="25%" class="value"><esrcore:displayValue name="eligibilityViewForm" property="primaryElig"/></td>
              <td width="25%" class="label"><bean-el:message key="label.veteranIndicator"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="veteranIndicator"/></td>
            </tr>
            <tr>
              <td class="darkLabel"><bean-el:message key="label.scPercentage"/>:</td>
              <td class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="scPercentage"/></td>
              <td class="darkLabel"><bean-el:message key="label.appDate"/>:</td>
              <td class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="applicationDate"/></td>
            </tr>
            <tr>
              <td class="label"><bean-el:message key="label.effectiveDateOfCombinedRating"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="effectiveDateCombinedRating"/></td>
              <td class="label"><bean-el:message key="label.effDate"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="enrollmentEffDate"/></td>
            </tr>
            <tr>
              <td class="darkLabel"><bean-el:message key="label.eligStatus"/>:</td>
              <td class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="eligStatus"/></td>
              <td class="darkLabel"><bean-el:message key="label.checkAmount"/>:</td>
              <td class="darkValue"><esrcore:displayCurrency name="eligibilityViewForm" currencyProperty="totalCheck"/></td>
            </tr>
            <tr>
              <td class="label"><bean-el:message key="label.eligStatusDate"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="eligStatusDate"/></td>
              <td class="label"><bean-el:message key="label.EligVeriMethod"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="eligVerMethod"/></td>
            </tr>
            <tr>
              <td class="darkLabel"><bean-el:message key="label.EligVeriSource"/>:</td>
              <td class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="eligVerSourceFacility"/></td>
              <td class="darkLabel">VBA Query Status :</td>
              <td class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="AACIndicator"/></td>
            </tr>
            <tr>
              <td class="label"><bean-el:message key="label.eligStatusPendingVerficationReason"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="eligStatusPVReason"/></td> 
              <td class="label"><bean-el:message key="label.MsdsQueryStatus"/>:</td>
              <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="MSDSQueryStatus"/></td>              
            </tr> 
            <tr>
              <td class="darkLabel"><bean-el:message key="label.eligStatusPendingVerficationReasonExp"/>:</td>
              <td class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="eligStatusPVReasonExplain"/></td>
              <td class="darkLabel"></td>
              <td class="darkValue"></td>             
            </tr> 
          </table>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
 <br>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline">Rated SC Disabilities</td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
           </tr>
          </table>
         </td>
        </tr>
        <tr width="100%">
         <TD vAlign="top" align="center">
          <table id="tableWL" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
           <c:choose>
            <c:when test="${vlhlist.valueListInfo.totalNumberOfEntries == 0}">
             <tr>
              <td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
             </tr>
            </c:when>
            <c:otherwise>
              <tr width="100%">
                <td vAlign="top" align="center">
                  <div id="ratedDisabilities" style="border-width:0px;">
                    <table id="ratedDisabilitiesTableResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                      <vlh:root id="ratedDisabilitiesTableId" value="vlhlist" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                      <vlh:addParam name="checkboxName" value="Select" temp="false"/>
                      <tr>
                        <td colspan="5">
                          <table class="pagelinks" role="presentation">
                            <tr>
                              <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                                <td width="5%" nowrap="true">
                                  <span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total
                                  - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).
                                  &nbsp;</span>
                                </td>
                                <td width="5%">
                              <c:choose>
                              <c:when test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                                <vlh:paging attributes="class=\"pagelinks\"" pages="20"><c:out value="${pageratedDisabilitiesTableId}"/>&nbsp;</vlh:paging>
                              </c:when>
                              <c:otherwise>
                                &nbsp;
                              </c:otherwise>
                              </c:choose>
                            </td>
                              <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                      <tr vAlign="top">
                        <td vAlign="top" align="center">
                          <table rules="all" class="TableDisplaySmall">
                           <caption style="display:none">ratedDisability</caption>
                            <tr>
                              <vlh:row bean="ratedDisability">
                                <vlh:column titleKey="label.code" property="disability.code" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'"default="">
                                  <vlh:attribute name="scope">row</vlh:attribute>
                                  <esrcore:displayValue name="ratedDisability" property="disability.code" nullText=""/></a>
                                </vlh:column>

                                <vlh:column titleKey="label.SCPersentage" property="percentage" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                                  <esrcore:displayValue name="ratedDisability" property="percentage" nullText=""/>
                                </vlh:column>

                                <vlh:column titleKey="label.description" property="disability.name" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                                </vlh:column>

                                <vlh:column titleKey="label.diagnosticExtremity" property="diagnosticExtremity.description" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                                </vlh:column>

                                <vlh:column titleKey="label.originalEffectiveDate" property="originalEffectiveRatingDate" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                                  <esrcore:displayDate name="ratedDisability" dateProperty="originalEffectiveRatingDate" displayTime="false" nullText=""/>
                                </vlh:column>

                                <vlh:column titleKey="label.currentEffectiveDate" property="ratingDate" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                                  <esrcore:displayDate name="ratedDisability" dateProperty="ratingDate" displayTime="false" nullText=""/>
                                </vlh:column>
                              </vlh:row>
                            </tr>
                          </table>
                        </td>
                      </tr>
                      </vlh:root>
                    </table>
                  </div>
                </td>
              </tr>
            </c:otherwise>
           </c:choose>
          </table>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
 <br>							  
 <c:if test="${viewPOW}">	 
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline" style="padding-left: 7"><bean-el:message key="eligibilityView.pow.title"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
              <fw:link action="/powHistory?methodName=DISPLAY&amp;history=viewHistoricalPOW">
                <bean-el:message key="text.viewHistoricalPOW"/>
              </fw:link>
            </td>
           </tr>
          </table>
         </td>
        </tr>
		<tr>
		<td>
		<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
		<tr>
		  <c:choose>			
			<c:when test="${eligibilityViewForm.powIndicator == null}">
		      <td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
			</c:when>
			<c:otherwise>
			   <td width="22%" class="moduleLabel"><bean-el:message key="label.prisonerOfWar"/>:</td>
			   <td width="28%" class="moduleValue">
				   <esrcore:displayValue name="eligibilityViewForm" property="powIndicator"/></td>
			   <td width="50%" class="moduleValue"><img alt=""  src="../images/spacer.gif"></td>
			</c:otherwise>
		  </c:choose>
		</tr>
	    </table>				   
	    </td>		
		</tr>					
				
        <tr>
         <td>
          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
          <c:forEach var="powEpisode" items="${eligibilityViewForm.powEpisodes}" varStatus="status">
          <tr>
           <td width="22%" class="moduleLabel"><bean-el:message key="label.powSource"/>:</td>
           <td width="28%" class="moduleValue">
			   <esrcore:displayValue name="powEpisode" property="dataSource"/></td>
           <td width="22%" class="moduleLabel"><bean-el:message key="label.powDocumentType"/>:</td>
           <td width="28%" class="moduleValue">
			   <esrcore:displayValue name="powEpisode" property="documentType"/></td>
          </tr>
 		  <tr>
			  <td class="moduleLabel"><bean-el:message key="label.powCaptureDate"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="captureDate"/></td>
			  <td class="moduleLabel"><bean-el:message key="label.powReleaseDate"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="releaseDate"/></td>
		   </tr>
 		   <tr>
			  <td class="moduleLabel"><bean-el:message key="label.powCaptivityDays"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="numberOfDaysInCaptivity"/></td>
			  <td class="moduleLabel"><bean-el:message key="label.powDateEntered"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="dateEntered"/></td>
		   </tr>						  				  		  
 		   <tr>
			  <td class="moduleLabel"><bean-el:message key="label.powConfinementLocation"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="confinementLocation"/></td>
			  <td class="moduleLabel"><bean-el:message key="label.powCampLocation"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="campLocation"/>
				  (<esrcore:displayValue name="powEpisode" property="campLocation.code"/>)				  
			  </td>
		   </tr>			  
 		   <tr>
			  <td class="moduleLabel"><bean-el:message key="label.powCampName"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="campLocation.name"/></td>
			  <td class="moduleLabel"><bean-el:message key="label.powCampCity"/>:</td>
			  <td class="moduleValue">
				  <esrcore:displayValue name="powEpisode" property="campLocation.description"/></td>
		   </tr>			  			  	  			  			 			  
		  </c:forEach>
       </table>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>	 	 
 </c:if>								  							  
 <br>
 
 <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline" style="padding-left: 7"><bean-el:message key="eligibilityView.healthBenefitPlan.title"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            <c:choose>
				<c:when test="${viewHbp}">
					<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
              			<fw:link action="/healthBenefitPlan.do?methodName=DisplayHealthBenefitPlan">
                			<bean-el:message key="text.viewHealthBenefitsPlans"/>
              			</fw:link>
            		</td>
				</c:when>
				<c:otherwise>
				</c:otherwise>
			</c:choose>
           </tr>
          </table>
         </td>
        </tr>
		<tr>
		<td>
		<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
		<tr>
			<td width="22%" class="moduleLabel"><bean-el:message key="label.currentNumberHealthBenefitPlans" />:</td>
			<td width="28%" class="moduleValue"><esrcore:displayValue name="eligibilityViewForm" property="currentNumberOfHealthBenefitPlans" /></td>
			<td width="50%" class="moduleValue"><img alt=""  src="../images/spacer.gif"></td>
		</tr>
	    </table>				   
	    </td>		
		</tr>					
       </table>
     </td>
    </tr>
   </table>	 	 							  							  
 <br>
 
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline"><bean-el:message key="eligibilityView.otherCodePanel.title"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
           </tr>
          </table>
         </td>
        </tr>
        <tr width="100%">
         <TD vAlign="top" align="center">
          <table id="tableWL" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
           <c:choose>
            <c:when test="${eligibilityViewForm.noOtherEligCodes == true}">
            <tr>
              <td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
            </tr>
            </c:when>
            <c:otherwise>
               <logic:notEmpty name="eligibilityViewForm" property="otherEligCodes">
                <tr><td width="33%"></td><td width="33%"></td><td width="33%"></td></tr>
                <TR width="100%">
                 <c:forEach var="elig" items="${eligibilityViewForm.otherEligCodes}" varStatus="status">
                  <c:if test="${status.index != 0 && status.index % 3 == 0}">
                    </TR><TR width="100%">
                  </c:if>

                  <td width="33%" class="moduleValue">
                   <c:out value="${elig.type.description}"/>
                   <c:choose>
                    <c:when test="${phEligibilityCode == elig.type.code}">
                     (<esrcore:displayValue name="eligibilityViewForm" property="phStatus"/>)
                    </c:when>
                   </c:choose>
                  </td>
                 </c:forEach>
                </TR>
               </logic:notEmpty>
            </c:otherwise>
           </c:choose>
          </TABLE>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
 <br>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline"><bean-el:message key="eligibilityView.otherFactorPanel.title"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            <auth:authorize access="hasAnyRole(${viewCD})">
            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                <fw:link action="/eligibilityView.displayClinicalDeter.do">
                    <bean-el:message key="text.viewClinicalDetermination"/>
                </fw:link>
            </td>
            </auth:authorize>
           </tr>
          </table>
         </td>
        </tr>
        <tr width="100%">
         <TD vAlign="top" align="center">
          <table id="tableWL" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
           <c:choose>
            <c:when test="${eligibilityViewForm.noOtherEligFactors == true}">
            <tr>
              <td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
            </tr>
            </c:when>
            <c:otherwise>
               <logic:notEmpty name="eligibilityViewForm" property="otherEligFactors">
                <tr width="100%">
                 <c:forEach var="elig" items="${eligibilityViewForm.otherEligFactors}" varStatus="status">
                  <c:if test="${status.index != 0 && status.index % 3 == 0}">
                    </TR><TR width="100%">
                  </c:if>
                  <c:choose>
                    <c:when test="${elig.factor.code == 'AG'}">
                  	<td width="33%" class="moduleValue" nowrap><esrcore:displayValue name="elig" property="factor.description"/><c:if test="${eligibilityViewForm.agentOrangeExposureLocation != null}"> Location - <esrcore:displayValue name="eligibilityViewForm" property="agentOrangeExposureLocation.description"/></c:if></td>
                    </c:when>
            	    <c:otherwise>
                  	<td width="33%" class="moduleValue" nowrap><esrcore:displayValue name="elig" property="factor.description"/></td>
                    </c:otherwise>
           	  </c:choose>
                  <c:if test="${status.last}">
                   <c:if test="${status.index % 3 == 2}">
                    <td width="33%" class="moduleValue">&nbsp;</td>
                   </c:if>
                   <c:if test="${status.index % 3 == 1}">
                    <td width="33%" class="moduleValue">&nbsp;</td>
                    <td width="33%" class="moduleValue">&nbsp;</td>
                   </c:if>
                  </c:if>
                 </c:forEach>
                </TR>
               </logic:notEmpty>
            </c:otherwise>
           </c:choose>
          </TABLE>

         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
   
   <!--   // Uncomment the following - Community Care - Nixon - Work Item - 429521 -->
   <!-- Comment Removed to show Community Care - Work Item - 440913 -->
  <br>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline"><bean-el:message key="eligibilityView.veteransChoice.title"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                <fw:link action="/eligibilityView.vcDetermination.do?methodName=vcDetermination">
                    <bean-el:message key="text.viewVeteransChoiceDetermination"/>
                </fw:link>
            </td>
           </tr>
          </table>
         </td>
        </tr>
        <tr width="100%">
         <TD vAlign="top" align="center">
			<table width="100%" border="0" cellpadding="0" cellspacing="0"
				class="moduleShell" role="presentation">
				<tr>
					<td>
						<table width="100%" border="0" cellpadding="0" cellspacing="0"
							class="moduleShellTable" role="presentation">
							<tr>
								<td>
									<table table width="100%" border="0" cellspacing="0"
										cellpadding="0" class="moduleShellTableBody" role="presentation">
										<c:if test="${vetChoiceStat == ''}">
										<tr>
											<td colspan="3" width="100%" class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
										</tr>
										</c:if>
										<c:if test="${vetChoiceStat == 'B'}">
										<tr>
											<td  width="22%" class="label">Community Care:</td>
											<td  width="28%" class="value">Basic</td>
											<td width="50%" class="value"><img alt=""  src="../images/spacer.gif"></td>
										</tr>
										</c:if>
										<c:if test="${vetChoiceStat == 'X'}">
										<tr>
											<td  width="22%" class="label">Community Care:</td>
											<td width="28%" class="value">Not eligible</td>
											<td width="50%" class="value"><img alt=""  src="../images/spacer.gif"></td>
										</tr>
										</c:if>
										<c:if test="${vetChoiceStat == 'M' || vetChoiceStat == 'MWT'}">
										<tr>
											<td  width="22%" class="label">Community Care:</td>
											<td width="28%" class="value">Mileage</td>
											<td width="50%" class="value"><img alt=""  src="../images/spacer.gif"></td>
										</tr>
										</c:if>
										<c:if test="${vetChoiceStat == 'WT' || vetChoiceStat == 'MWT' || vetChoiceStat == 'HWT'}">
										<tr>
											<td  width="22%" class="label">Community Care:</td>
											<td width="28%" class="value">Wait-Time</td>
											<td width="50%" class="value"><img alt=""  src="../images/spacer.gif"></td>
										</tr>
										</c:if>
										<c:if test="${vetChoiceStat == 'H' || vetChoiceStat == 'HWT'}">
										<tr>
											<td  width="22%" class="label">Community Care:</td>
											<td width="28%" class="value">Hardship</td>
											<td width="50%" class="value"><img alt=""  src="../images/spacer.gif"></td>
										</tr>
										</c:if>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
  <br>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td nowrap class="moduleHeadline"><bean-el:message key="label.otherIneligibility"/></td>
            <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
           </tr>
          </table>
         </td>
        </tr>
        <tr width="100%">
         <TD vAlign="top" align="center">
          <table id="tableWL" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
           <c:choose>
            <c:when test="${eligibilityViewForm.ineligibilityFactor != null}">
              <tr>
               <td width="240" class="label"><bean-el:message key="label.ineligibleDate"/>:</td>
               <td width="200" class="value"><esrcore:displayDate name="eligibilityViewForm" dateProperty="ineligibilityFactor.ineligibleDate" displayTime="false" nullText=""/></td>
               <td width="200" class="label"><bean-el:message key="label.ineligibleVARODecision"/>:</td>
               <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="ineligibilityFactor.varoDecision"/></td>
              </tr>
              <tr>
               <td width="240" class="label"><bean-el:message key="label.ineligibleReason"/>:</td>
               <td width="200" class="value"><esrcore:displayValue name="eligibilityViewForm" property="ineligibilityFactor.reason"/></td>
               <td width="200" class="label">&nbsp</td>
               <td class="value">&nbsp</td>
              </tr>
            </c:when>
            <c:otherwise>
              <tr>
               <td colspan="4" width="100%" class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
              </tr>
            </c:otherwise>
           </c:choose>
          </table>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
  <br>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
    <tr>
     <td>
       <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
         <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
           <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
            <td class="moduleHeadline">
                <bean-el:message key="eligibilityView.financialPanel.title"/>
                <esrcore:displayValue name="eligibilityViewForm" property="incomeTestYear"/>
            </td>
           </tr>
          </table>
         </td>
        </tr>
        <tr>
         <td>
          <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
           <c:choose>
            <c:when test="${eligibilityViewForm.noFinancialData == true}">
            <tr>
              <td class="moduleLabel" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noCurrentIncomeTestDataAvailable"/></td>
            </tr>
            </c:when>
            <c:otherwise>
             <tr>
               <td width="240" class="label"><bean-el:message key="label.dateAssessmentConducted"/>:</td>
               <td width="200" class="value"><esrcore:displayValue name="eligibilityViewForm" property="incomeTestDate"/></td>
               <td width="200" class="label"><bean-el:message key="label.facilityConductingAssessment"/>: </td>
               <td class="value"><esrcore:displayValue name="eligibilityViewForm" property="incomeTestFacility"/> </td>
             </tr>
             <tr>
               <td width="240" class="darkLabel"><bean-el:message key="label.meansTestStatus"/>:</td>
               <td width="200" class="darkValue"><esrcore:displayValue name="eligibilityViewForm" property="incomeTestStatus"/></td>
               <td width="200" class="darkLabel">&nbsp;</td>
               <td class="darkValue">&nbsp;</td>
             </tr>
            </c:otherwise>
           </c:choose>
          </table>
         </td>
        </tr>
       </table>
     </td>
    </tr>
   </table>
          
<script type="text/javascript">
	onLoadInit();
</script>
