<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msg="ORU-Z07">

	<xsl:template match="/">
	
 
	<html>	
		<head>
			<link rel="stylesheet" type="text/css" href="MainStyleSheet.css"> </link>
		</head>
	<body>
		<table border="1" rules="none" frame="box" cellpadding="3" cellspacing="0" class="HL7Table">
			<col width="300"></col>
			<col width="300"></col>
			<tr> 
				<th align="left" colspan="2" class="HL7TableHeader"></th>
			</tr>
			<tr>
				<td colspan="2" class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">MSH - Message Header </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">FIELD SEPARATOR:
					<br/>
				</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@fieldSeparator">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENCODING CHARACTERS:</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@encodingCharacters">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SENDING APPLICATION:</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@sendingApplication">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SENDING FACILITY:</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@sendingFacility">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RECEIVING APPLICATION:</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@receivingApplication">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RECEIVING FACILITY:</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@receivingFacility">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME OF MESSAGE:</td>
				<xsl:for-each select="//msg:msh">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@messageDateTime">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NAME/ID/TYPE:</td>
				<td class="HL7TableStdRow">MESSAGE TYPE: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@messageType">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each><br/>
MESSAGE CONTROL ID: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@messageControlIdentifier">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each><br/>
PROCESSING ID: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@processingID">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each><br/>
VERSION ID: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@versionID">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each><br/>
ACCEPT ACKNOWLEDGMENT TYPE: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@acceptAcknowledgmentType">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each><br/>
APPLICATION ACKNOWLEDGMENT TYPE: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@applicationAcknowledgmentType">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each><br/>
COUNTRY CODE: <xsl:for-each select="//msg:msh">
						<xsl:for-each select="@countryCode">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</xsl:for-each></td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">PID - Patient Identification Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID - PATIENT ID:
					<br/>
				</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@setIdentifier">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT IDENTIFIER:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@patientIdentifier">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT NAME:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@patientName">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MOTHER'S MAIDEN NAME:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@mothersMaidenName">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE /TIME OF BIRTH:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@birthDateTime">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SEX:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@sex">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT ALIAS:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@patientAlias">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RACE:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@race">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT ADDRESS:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@patientAddress">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">COUNTY CODE:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@countyCode">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PHONE NUMBER - HOME:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@homePhoneNumber">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PHONE NUMBER - BUSINESS:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@businessPhoneNumber">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MARITAL STATUS:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@maritalStatus">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RELIGION:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@religion">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SSN NUMBER - PATIENT:</td>
				<xsl:for-each select="//msg:pid">
					<td class="HL7TableStdRow">
						<xsl:for-each select="@patientSSN">
							<xsl:value-of select="."/>
						</xsl:for-each>
					</td>
				</xsl:for-each>								
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">PD1 - Patient Demographic Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CIRN (Master of Record):</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">Station Number:</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT PRIMARY CARE PROVIDER NAME &amp; ID No:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">ZPD - VA Specific Patient Info Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID - PATIENT ID:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REMARKS:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLACE OF BIRTH CITY:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLACE OF BIRTH STATE:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CURRENT MEANS TEST STATUS:</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">FATHER'S NAME:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MOTHER'S NAME:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RATED INCOMPETENT:</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE OF DEATH:</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">COLLATERAL SPONSOR:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ACTIVE HEALTH INSURANCE?:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBLE FOR MEDICAID?:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE MEDICAID LAST ASKED:</td>
				<td class="HL7TableStdRow">200408101611-0500</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RACE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RELIGION:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HOMELESS INDICATOR:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">POW STATUS INDICATED?:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF INSURANCE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEDICATION COPAYMENT EXEMPTION STATUS:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZTA - VA Specific Temporary Address Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID - PATIENT ID:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEMPORARY ADDRESS?:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEMPORARY ADDRESS START:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEMPORARY ADDRESS END:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEMPORARY ADDRESS:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEMPORARY ADDRESS COUNTY:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEMPORARY ADDRESS PHONE:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">ZIE - VA Specific Patient Ineligible Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INELIGIBLE DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INELIGIBLE REASON:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INELIGIBLE VARO DECISION:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INELIGIBLE TWX CITY:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INELIGIBLE TWX SOURCE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INELIGIBLE TWX STATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MISSING PERSON DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MISSING PERSON TWX CITY:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MISSING PERSON TWX SOURCE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MISSING PERSON TWX STATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">ZEL - VA Specific Patient Eligibility Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow"> 1</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBILITY CODE:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow"> 1 </span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">LONG ID:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SHORT ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DISABILITY RETIREMENT FROM MIL:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CLAIM FOLDER NUMBER:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">380204388</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CLAIM FOLDER LOCATION:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">325CLEVELAND-RO</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">VETERAN?:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">V</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF PATIENT:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBLITY STATUS:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBILITY STATUS DATE:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">20040810</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBLILITY INTERIM RESPONSE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBILITY VERIFICATION METHOD:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">DD 214</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RECEIVING A&amp;A BENEFITS?:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow"> 0</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RECEIVING HOUSEBOUND BENEFITS?:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow"> 0</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RECEIVING A VA PENSION?:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow"> 0</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RECEIVING A VA DISABILITY?:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">1 </span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EXPOSED TO AGENT ORANGE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RADIATION EXPOSURE INDICATED:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENVIRONMENTAL CONTAMINANTS:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL ANNUAL VA CHECK AMOUNT:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">58300</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RADIATION EXPOSURE METHOD:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MST STATUS:</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">U</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MST STATUS CHANGE DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SITE DETERMINING MST STATUS:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGENT ORANGE REGISTRATION DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGENT ORANGE EXAM DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGENT ORANGE REGISTRATION NUMBER:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGENT ORANGE EXPOSURE LOCATION:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RADIATION REGISTRATION DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENVIRONMENTAL CONTAMINANTS EXAM DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENVIRONMENTAL CONTAMINANTS REGISTRATION DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MONETARY BENEFITS DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">USER ENROLLEE VALID THROUGH:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">USER ENROLLEE SITE:</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBILITY VERIFICATION SOURCE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZEN - VA Specific Enrollment Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1 </td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENROLLMENT DATE:</td>
				<td class="HL7TableStdRow">20040810</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF ENROLLMENT:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENROLLMENT STATUS:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REASON CANCELED/DECLINED:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CANCELED/DECLINED REMARKS:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">FACILITY RECEIVED:</td>
				<td class="HL7TableStdRow">605</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PREFERRED FACILITY:</td>
				<td class="HL7TableStdRow">605</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENROLLMENT PRIORITY:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EFFECTIVE DATE:</td>
				<td class="HL7TableStdRow">20040810</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENROLLMENT APPLICATION DATE:</td>
				<td class="HL7TableStdRow">20040810</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENROLLMENT END DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ENROLLMENT SUB-GROUP:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZCD - VA Specific Catastrophic Disability Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REVIEW DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DECIDED BY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">FACILITY MAKING DETERMINATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE OF DECISION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DETERMINATION METHOD:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CD DIAGNOSIS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CD PROCEDURE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AFFECTED EXTREMITY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CD CONDITION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SCORE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CATASTROPHICALLY DISABLED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PERMANENT INDICATOR:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>							<tr>
	<td class="HL7TableHeaderRow">ZMH - VA Specific Military History Segment</td>
	<td class="HL7TableHeaderRow">
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</td>
</tr>
<tr>
								<td class="HL7TableRowTitle" width="354">setIdentifier</td>
								<xsl:for-each select="msg:zmh">
									<td class="HL7TableStdRow">
										<xsl:for-each select="@setIdentifier">
											<xsl:value-of select="."/>
										</xsl:for-each>
									</td>
								</xsl:for-each>
							</tr>
							<tr>
								<td class="HL7TableRowTitle" width="354">militaryStatusType</td>
								<xsl:for-each select="msg:zmh">
									<td class="HL7TableStdRow">
										<xsl:for-each select="@militaryStatusType">
											<xsl:value-of select="."/>
										</xsl:for-each>
									</td>
								</xsl:for-each>
							</tr>
							<tr>
								<td class="HL7TableRowTitle" width="354">serviceIndicator</td>
								<xsl:for-each select="msg:zmh">
									<td class="HL7TableStdRow">
										<xsl:for-each select="@serviceIndicator">
											<xsl:value-of select="."/>
										</xsl:for-each>
									</td>
								</xsl:for-each>
							</tr>
							<tr>
								<td class="HL7TableRowTitle" width="354">serviceDateRange</td>
								<xsl:for-each select="msg:zmh">
									<td class="HL7TableStdRow">
										<xsl:for-each select="@serviceDateRange">
											<xsl:value-of select="."/>
										</xsl:for-each>
									</td>
								</xsl:for-each>
							</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZRD - VA Specific Rated Disabilities Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DISABILITY CONDITION:
					<br/>
				</td>
				<td class="HL7TableStdRow">9411: 
					<span class="HL7TableStdRow">POST-TRAUMATIC STRESS DISORDER</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DISABILITY %:
					<br/>
				</td>
				<td class="HL7TableStdRow">100</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE CONNECTED RATED DISABILITY:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE CONNECTED CONDITIONS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PERCENTAGE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE DENTAL INJURY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE TEETH EXTRACTED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE OF DENTAL TREATMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONDITION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE CONDITION FIRST NOTICED:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZCT - VA Specific Emergency Contact Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT TYPE:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT RELATIONSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT ADDRESS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT PHONE NUMBER:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT WORK PHONE NUMBER:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT ADDRESS SAME AS NOK?:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTACT PERSON SAME AS NOK?:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZEM - VA Specific Employment Info Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYMENT PERSON:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYMENT STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">3</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYER NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">OCCUPATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYER ADDRESS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYER PHONE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GOVERNMENT AGENCY:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZEM - VA Specific Employment Info Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">2</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYMENT PERSON:
					<br/>
				</td>
				<td class="HL7TableStdRow">2</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYMENT STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYER NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">OCCUPATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYER ADDRESS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYER PHONE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GOVERNMENT AGENCY:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZGD - VA Specific Guardian Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN TYPE:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN INSTITUTION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN RELATIONSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN ADDRESS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN PHONE NUMBER:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE RULED INCOMPETENT:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZGD - VA Specific Guardian Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN TYPE:</td>
				<td class="HL7TableStdRow">2</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN INSTITUTION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN RELATIONSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN ADDRESS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GUARDIAN PHONE NUMBER:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE RULED INCOMPETENT:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZIC - VA Specific Income Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME YEAR:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">20030000</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOCIAL SECURITY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">US CIVIL SERVICE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">US RAILROAD RETIREMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MILITARY RETIREMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">UNEMPLOYMENT COMPENSATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">OTHER RETIREMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYMENT INCOME:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZIR - VA Specific Income Relation Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MARRIED LAST CALENDAR YEAR:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">LIVED WITH PATIENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AMOUNT CONTRIBUTED TO SPOUSE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEPENDENT CHILDREN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCAPABLE OF SELF-SUPPORT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTRIBUTED TO SUPPORT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CHILD HAD INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME AVAILABLE TO YOU:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NUMBER OF DEPENDENT CHILDREN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS NOT APPLICABLE FOR MT INDICATORS AS,N,X,U:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZDP - VA Specific Patient Info Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID - PATIENT ID:
					<br/>
				</td>
				<td class="HL7TableStdRow"><br/> 
          1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REMARKS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLACE OF BIRTH CITY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLACE OF BIRTH STATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CURRENT MEANS TEST STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">FATHER'S NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MOTHER'S NAME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RATED INCOMPETENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE OF DEATH:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">COLLATERAL SPONSOR:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ACTIVE HEALTH INSURANCE?:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBLE FOR MEDICAID?:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE MEDICAID LAST ASKED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RACE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">RELIGION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HOMELESS INDICATOR:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">POW STATUS INDICATED?:
					<br/>
				</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF INSURANCE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEDICATION COPAYMENT EXEMPTION STATUS:</td>
				<td class="HL7TableStdRow">0000</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZIC - VA Specific Income Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME YEAR:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOCIAL SECURITY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">US CIVIL SERVICE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">US RAILROAD RETIREMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MILITARY RETIREMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">UNEMPLOYMENT COMPENSATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">OTHER RETIREMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EMPLOYMENT INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INTEREST, DIVIDEND, ANNUITY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">WORKERS COMP/BLACK LUNG:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">OTHER INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEDICAL EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">FUNERAL AND BURIAL EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EDUCATIONAL EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CASH, AMOUNT IN BANK ACCOUNTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">STOCKS AND BONDS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REAL PROPERTY:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">OTHER PROPERTY OR ASSETS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEBTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE INCOME SCREENING COLLECTED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SITE CONDUCTING TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF TEST:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">ZIR -  VA Specific Income Relation Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MARRIED LAST CALENDAR YEAR:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">LIVED WITH PATIENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AMOUNT CONTRIBUTED TO SPOUSE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEPENDENT CHILDREN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCAPABLE OF SELF-SUPPORT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CONTRIBUTED TO SUPPORT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">CHILD HAD INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME AVAILABLE TO YOU:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NUMBER OF DEPENDENT CHILDREN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PATIENT INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS NOT APPLICABLE FOR MT INDICATORS AS,N,X,U:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZIO - VA Specific Patient Info Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NUMBER OF INPATIENT DAYS SINCE LAST MEANS TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NUMBER OF OUTPATIENT DAYS SINCE LAST MEANS TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">0</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE OF LAST VISIT:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">NTE - 


Notes and Comments Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID - NTE:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF COMMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">COMMENT:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">COMMENT TYPE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow">IN1 - 


Insurance Segment</td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID-IN1:</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INSURANCE COMPANY NAME:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INSURANCE COMPANY ADDRESS:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INSURANCE CO. PHONE NUMBER:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GROUP NUMBER:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GROUP NAME:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLAN EFFECTIVE DATE:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLAN EXPIRATION DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AUTHORIZATION INFORMATION:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PLAN TYPE:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NAME OF INSURED:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INSURED'S RELATION TO PATIENT:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PRE-ADMIT CERT. (PAC):</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">POLICY NUMBER:</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZMT - VA Specific Means Test Information Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NET WORTH:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME OF ADJUDICATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGREED TO PAY DEDUCTIBLE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">THRESHOLD A:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEDUCTIBLE EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PREVIOUS YR MT THRESHOLD FLAG:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE VETERAN SIGNED TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DECLINES TO GIVE INCOME INFO:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PRIMARY TEST?:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE IVM VERIF. MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REFUSED TO SIGN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SITE CONDUCTING TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW SITE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP EFFECTIVE DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME TEST LAST EDITED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEST DETERMINED STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Means Test Signature Indicator:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GMT Threshold:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Hardship Reason:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZMT - VA Specific Means Test Information Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NET WORTH:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME OF ADJUDICATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGREED TO PAY DEDUCTIBLE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">THRESHOLD A:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEDUCTIBLE EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PREVIOUS YR MT THRESHOLD FLAG:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE VETERAN SIGNED TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DECLINES TO GIVE INCOME INFO:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PRIMARY TEST?:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE IVM VERIF. MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REFUSED TO SIGN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SITE CONDUCTING TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW SITE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP EFFECTIVE DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME TEST LAST EDITED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEST DETERMINED STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Means Test Signature Indicator:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GMT Threshold:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Hardship Reason:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZMT - VA Specific Means Test Information Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">2</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NET WORTH:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME OF ADJUDICATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGREED TO PAY DEDUCTIBLE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">THRESHOLD A:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEDUCTIBLE EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PREVIOUS YR MT THRESHOLD FLAG:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE VETERAN SIGNED TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DECLINES TO GIVE INCOME INFO:
					<br/>
				</td>
				<td class="HL7TableStdRow">2</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PRIMARY TEST?:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE IVM VERIF. MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REFUSED TO SIGN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SITE CONDUCTING TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW SITE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP EFFECTIVE DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME TEST LAST EDITED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEST DETERMINED STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Means Test Signature Indicator:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GMT Threshold:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Hardship Reason:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZMT - VA Specific Means Test Information Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">4</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">INCOME:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">NET WORTH:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME OF ADJUDICATION:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AGREED TO PAY DEDUCTIBLE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">THRESHOLD A:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DEDUCTIBLE EXPENSES:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PREVIOUS YR MT THRESHOLD FLAG:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TOTAL DEPENDENTS:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE VETERAN SIGNED TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DECLINES TO GIVE INCOME INFO:
					<br/>
				</td>
				<td class="HL7TableStdRow">4</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TYPE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SOURCE OF TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PRIMARY TEST?:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE IVM VERIF. MT COMPLETED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REFUSED TO SIGN:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SITE CONDUCTING TEST:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP REVIEW SITE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">HARDSHIP EFFECTIVE DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE/TIME TEST LAST EDITED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TEST DETERMINED STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Means Test Signature Indicator:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">GMT Threshold:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">Hardship Reason:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZBT - VA Specific Beneficiary Travel Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">DATE CERTIFIED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ELIGIBLE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">AMOUNT CERTIFIED:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">MEANS TEST STATUS:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PRIMARY ELIGIBILITY CODE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">TRAVEL CLAIM DATE/TIME:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> ZSP - VA Specific Service Period Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SET ID:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE CONNECTED?:
					<br/>
				</td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE CONNECTED PERCENTAGE:
					<br/>
				</td>
				<td class="HL7TableStdRow">100</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PERIOD OF SERVICE:
					<br/>
				</td>
				<td class="HL7TableStdRow">7</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">VIETNAM SERVICE INDICATED?:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">P&amp;T:
					<br/>
				</td>
				<td class="HL7TableStdRow">"'</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">UNEMPLOYABLE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SC AWARD DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">""</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">SERVICE VERIFICATION DATE:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> RF1 - Referral Information Segment </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">ORIGINATING REFERRAL IDENTIFIER:
					<br/>
				</td>
				<td class="HL7TableStdRow"> SITE OF CHANGE: <span class="HL7TableStdRow">605</span><br/>
        SOURCE OF CHANGE: <span class="HL7TableStdRow">USVAMC</span></td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EFFECTIVE DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<span class="HL7TableStdRow">20040810161112-0500</span>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">EXPIRATION DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">PROCESS DATE:
					<br/>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">REFERRAL REASON:</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableHeaderRow"> BTS - Batch Trailer </td>
				<td class="HL7TableHeaderRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle"> BATCH MESSAGE COUNT: </td>
				<td class="HL7TableStdRow">1</td>
			</tr>
			<tr>
				<td class="HL7TableRowTitle">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
				<td class="HL7TableStdRow">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
				</td>
			</tr>
		</table>
	</body>
	</html>
	</xsl:template>
</xsl:stylesheet>
