<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/displaytag" prefix="display" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>

<c:set var="displayRequiredFieldsIndicator" scope="page" value="false"/>
<c:set var="zipCodeLookup" scope="page" value="true"/>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>

<script>
function setGroupName(form)
{
	if(form.typeOfMedicare != null)
	{
	 form.groupName.value = form.typeOfMedicare.value;
	 form.groupNumber.value = form.typeOfMedicare.value;
	}
}
</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role="presentation">
 <html-el:hidden name="insuranceInfoForm" styleId="idDateOfDeath" property="dateOfDeath"></html-el:hidden>
<html-el:hidden name="insuranceInfoForm" styleId="idDateOfBirth" property="dateOfBirth"></html-el:hidden>

<c:choose>
<c:when test="${insuranceInfoForm.insCompanyName != 'Medicare'}">
	<tr>
	<td width="45%" class="moduleLabel"><fw:label required="true" property="insCompanyName" forId="txtInsCompanyName"><bean-el:message key="label.ins.insurance" />:</fw:label></td>
	<c:set var="insuranceText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.ins.insurance"/></c:set>
	<td width="55%" class="moduleValue"><html-el:text title="${insuranceText}" styleClass="moduleEdit" property="insCompanyName" styleId="txtInsCompanyName" size="40" maxlength="30"/> </td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="typeOfIns" forId="txtTypeOfIns"><bean-el:message key="label.ins.typeofins" />:</fw:label></td>
	<td class="moduleValue">
	<c:set var="typeofinsText"><bean-el:message key="label.ins.typeofins"/></c:set>
	    <html-el:select title="${typeofinsText}" styleClass="darkValue" property="typeOfIns" styleId="txtTypeOfIns">
	    <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
		<esrcore:options collection="gov.va.med.esr.common.model.lookup.InsurancePlanType" property="code" labelProperty="description"/>
	    </html-el:select>
	</td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="policyNumber" forId="txtPolicyNumber"><bean-el:message key="label.ins.policynumber" />:</fw:label></td>
	<c:set var="policynumberText"><bean-el:message key="label.ins.policynumber"/></c:set>
	<td class="moduleValue"><html-el:text title="${policynumberText}" styleClass="moduleEdit" property="policyNumber" styleId="txtPolicyNumber" size="40" maxlength="20"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="groupName" forId="txtGroupName"><bean-el:message key="label.ins.groupname" />:</fw:label></td>
	<c:set var="groupnameText"><bean-el:message key="label.ins.groupname"/></c:set>
	<td class="moduleValue"><html-el:text title="${groupnameText}" styleClass="moduleEdit" property="groupName" styleId="txtGroupName" size="25" maxlength="20"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="groupNumber" forId="txtGroupNumber"><bean-el:message key="label.ins.groupnumber"/>:</fw:label></td>
	<c:set var="groupnumberText"><bean-el:message key="label.ins.groupnumber"/></c:set>
	<td class="moduleValue"><html-el:text title="${groupnumberText}" styleClass="moduleEdit" property="groupNumber" styleId="txtGroupNumber" size="25" maxlength="17"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="nameOfInsured" forId="txtNameOfInsured"><bean-el:message key="label.ins.nameofinsured" />:</fw:label></td>
	<c:set var="nameofinsuredText"><bean-el:message key="label.ins.nameofinsured"/></c:set>
	<td class="moduleValue"><html-el:text title="${nameofinsuredText}" styleClass="moduleEdit" property="nameOfInsured" styleId="txtNameOfInsured" size="40" maxlength="35"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label required="true" property="relationshipToVeteran" forId="txtRelationshipToVeteran"><bean-el:message key="label.ins.insuredrelationshiptovet"/>:</fw:label></td>
	<td class="moduleValue">
	<c:set var="insuredrelationshiptovetText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.ins.insuredrelationshiptovet"/></c:set>
	    <html-el:select title="${insuredrelationshiptovetText}" styleClass="darkValue" property="relationshipToVeteran" styleId="txtRelationshipToVeteran">
	    <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
		<esrcore:options collection="gov.va.med.esr.common.model.lookup.InsuredRelationship" property="code" labelProperty="description"/>
	    </html-el:select>
	</td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="effDate" forId="txtEffDate"><bean-el:message key="label.ins.effectivedate"/>:</fw:label></td>
	<c:set var="effectivedateText"><bean-el:message key="label.ins.effectivedate"/>&nbsp;<c:out value="${mmddyyyyText}" /></c:set>
	<td class="moduleValue"><html-el:text title="${effectivedateText}" styleClass="moduleEdit" property="effDate" styleId="txtEffDate" size="25" maxlength="25"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="expDate" forId="txtExpDate"><bean-el:message key="label.ins.planexpdate" />:</fw:label></td>
	<c:set var="planexpdateText"><bean-el:message key="label.ins.planexpdate"/>&nbsp;<c:out value="${mmddyyyyText}" /></c:set>
	<td class="moduleValue"><html-el:text title="${planexpdateText}" styleClass="moduleEdit" property="expDate" styleId="txtExpDate" size="25" maxlength="25"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
	</tr>
	<tr>
	<td class="moduleLabel"><bean-el:message key="label.ins.precertrequired" />:</td>
	<td class="moduleValue">
		<c:forEach var="item" items="${yesNoList}">
			<c:set var="precertrequiredText"><bean-el:message key="label.ins.precertrequired"/>&nbsp;(<bean-el:message key="${item.label}" />)</c:set>
			<html-el:radio title="${precertrequiredText}" property="precertReq" styleId="txtPrecertReq_${item.value}" value="${item.value}" /><fw:label property="precertReq" forId="txtPrecertReq_${item.value}"><bean-el:message key="${item.label}" />&nbsp;&nbsp;</fw:label>
	   </c:forEach>
	</td>
	</tr>
</c:when>
<c:otherwise>
	<tr>
	<td width="45%" class="moduleLabel"><fw:label property="insCompanyName" forId="insCompanyNamext"><bean-el:message key="label.ins.insurance" />:</fw:label></td>	
	<td width="55%" class="moduleValue"><html-el:text title="${insurancepText}" styleClass="moduleEdit" property="insCompanyName" styleId="insCompanyNamext" size="40" maxlength="30" readonly="true"/> </td>
	</tr>


	<tr>
	<td class="moduleLabel"><fw:label property="typeOfMedicare" forId="txtTypeOfMedicare"><bean-el:message key="label.ins.medicare.typeofins" />:</fw:label></td>
	<td class="moduleValue">
	<c:set var="medTypeofinsText"><bean-el:message key="label.ins.medicare.typeofins"/></c:set>
	    <html-el:select title="${medTypeofinsText}" styleClass="darkValue" property="typeOfMedicare" styleId="txtTypeOfMedicare" onchange="setGroupName(this.form); return false;">
	    <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
	    <html-el:option value="Part A">A</html-el:option>
	    <html-el:option value="Part B">B</html-el:option>
	    <html-el:option value="Part A and B">A and B</html-el:option>
	    </html-el:select>
	</td>
	</tr>

	<tr>
	<td class="moduleLabel"><fw:label required="true" property="medicareClaimNbr" forId="txtMedicareClaimNbr"><bean-el:message key="label.ins.medicare.claimnbr" />:</fw:label></td>
	<c:set var="medClaimnbrText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.ins.medicare.claimnbr"/></c:set>
	<td class="moduleValue"><html-el:text title="${medClaimnbrText}" styleClass="moduleEdit" property="medicareClaimNbr" styleId="txtMedicareClaimNbr" size="40" maxlength="25"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label required="true" property="nameOnMedicareCard" forId="txtNameOnMedicareCard"><bean-el:message key="label.ins.medicare.nameoncard" />:</fw:label></td>
	<c:set var="medicareNameoncardText"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.ins.medicare.nameoncard"/></c:set>
	<td class="moduleValue"><html-el:text title="${medicareNameoncardText}" styleClass="moduleEdit" property="nameOnMedicareCard" styleId="txtNameOnMedicareCard" size="40" maxlength="35"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="groupName" forId="groupNamext"><bean-el:message key="label.ins.groupname" />:</fw:label></td>	
	<td class="moduleValue"><html-el:text title="${groupnameText}" styleClass="moduleEdit" property="groupName" styleId="groupNamext" size="25" maxlength="20" readonly="true"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="groupNumber" forId="groupNumberTxt"><bean-el:message key="label.ins.groupnumber" />:</fw:label></td>	
	<td class="moduleValue"><html-el:text title="${groupnumberText}" styleClass="moduleEdit" property="groupNumber" styleId="groupNumberTxt" size="25" maxlength="17" readonly="true"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="partAEffectiveDate" forId="partAEffectiveDateTxt"><bean-el:message key="label.ins.medicare.partaeffectivedate" />:</fw:label></td>
	<c:set var="medPartaeffectivedateText"><bean-el:message key="label.ins.medicare.partaeffectivedate"/></c:set>
	<td class="moduleValue"><html-el:text title="${medPartaeffectivedateText}" styleClass="moduleEdit" property="partAEffectiveDate" styleId="partAEffectiveDateTxt" size="25" maxlength="25"/></td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="partBEffectiveDate" forId="partBEffectiveDateTxt"><bean-el:message key="label.ins.medicare.partbeffectivedate" />:</fw:label></td>
	<c:set var="medPartbeffectivedateText"><bean-el:message key="label.ins.medicare.partbeffectivedate"/></c:set>
	<td class="moduleValue"><html-el:text title="${medPartbeffectivedateText}" styleClass="moduleEdit" property="partBEffectiveDate" styleId="partBEffectiveDateTxt" size="25" maxlength="25"/></td>
	</tr>
</c:otherwise>
</c:choose>
    <tr>
      <td colspan="2">
        <%@ include file="/tiles/common/addressForm.jsp" %>
      </td>
    </tr>
  <tr>
    <td class="moduleLabel"><fw:label property="preCertificationPhone" forId="preCertificationPhoneTxt"><bean-el:message key="label.ins.preCertificationPhone" />:</fw:label></td>
      <c:set var="preCertificationPhoneText"><bean-el:message key="label.ins.preCertificationPhone"/></c:set>
    <td class="moduleValue"> <html-el:text title="${preCertificationPhoneText}" styleClass="moduleEdit" property="preCertificationPhone" styleId="preCertificationPhoneTxt" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/> </td>
  </tr>
  <tr>
  <td class="moduleLabel"><fw:label property="phone" forId="phoneTxt"><bean-el:message key="label.ins.carrierphone" />:</fw:label></td>
  <c:set var="carrierphoneText"><bean-el:message key="label.ins.carrierphone"/></c:set>
  <td class="moduleValue"> <html-el:text title="${carrierphoneText}" styleClass="moduleEdit" property="phone" styleId="phoneTxt" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/> </td>
  </tr>
  <tr>
    <td class="moduleLabel"><fw:label property="fax" forId="faxTxt"><bean-el:message key="label.ins.carrierfax" />:</fw:label></td>
  <c:set var="carrierfaxText"><bean-el:message key="label.ins.carrierfax"/></c:set>
  <td class="moduleValue"> <html-el:text title="${carrierfaxText}" styleClass="moduleEdit" property="fax" styleId="faxTxt" size="25" maxlength="20" onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/> </td>
  </tr>
  <tr>
    <td class="moduleLabel"><fw:label property="sourceOfUpdate" forId="sourceOfUpdateTxt"><bean-el:message key="label.ins.sourceoflastupdate" />:</fw:label></td>
	<td class="moduleValue">
	<c:set var="sourceoflastupdateText"><bean-el:message key="label.ins.sourceoflastupdate"/></c:set>
	<html-el:select title="${sourceoflastupdateText}" styleClass="darkValue" property="sourceOfUpdate" styleId="sourceOfUpdateTxt" >
		<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
		<esrcore:options collection="gov.va.med.esr.common.model.lookup.InsuranceReportSource" property="code" labelProperty="description"/>
	</html-el:select>
	</td>

  </tr>

  <tr>
  <td class="moduleLabel">&nbsp;</td>
  <td class="moduleValue">&nbsp;</td>
  </tr>

 </table>
