<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%@ taglib uri="/tags/struts-nested" prefix="nested" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import='gov.va.med.esr.common.model.lookup.AddressChangeSource' %>
<%@ page import='gov.va.med.esr.common.model.lookup.PhoneSourceOfChange' %>
<%@ page import='gov.va.med.esr.common.model.lookup.EmailSourceOfChange' %>
<%@ page import="gov.va.med.esr.common.model.lookup.VAFacility" %>
<%@ page import="gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType" %>

<c:set var="notDefined" scope="page"><bean-el:message key="label.isNotDefined"/></c:set>
<c:set var="current" scope="page"><bean-el:message key="label.isCurrent"/></c:set>
<c:set var="notYetCurrent" scope="page"><bean-el:message key="label.isNotYetCurrent"/></c:set>
<c:set var="expired" scope="page"><bean-el:message key="label.hasExpired"/></c:set>
<c:set var="confAddressText"><bean-el:message key="label.addresses.confidentialAddressHeader"/></c:set>
<c:set var="tempAddressText"><bean-el:message key="label.addresses.temporaryAddressHeader"/></c:set>

<!--<script src="../scripts/ESR-Script.js" type="text/javascript"></script> -->
<c:set var="addressVamcConstant"><%= AddressChangeSource.CODE_VAMC.getName() %></c:set>
<c:set var="phoneVamcConstant"><%= PhoneSourceOfChange.CODE_VAMC.getName() %></c:set>
<c:set var="emailVamcConstant"><%= EmailSourceOfChange.CODE_VAMC.getName() %></c:set>
<c:set var="hecFacilityConstant"><%= VAFacility.CODE_HEC.getName() %></c:set>
<c:set var="phoneCount" value="${demographicAddressesForm.phoneSize}"/>
<c:set var="emailCount" value="${demographicAddressesForm.emailSize}"/>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="vAddressType" value="${demographicAddressesForm.addressType}"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="person" value="${appData[personKey]}"/>
<c:set var="viewHistoricalAddresses" scope="page"><bean-el:message key="text.viewHistoricalAddresses"/></c:set>
<c:set var="countryEditable" scope="page" value="true"/>
<c:set var="displayRequiredFieldsIndicator" scope="page" value="true"/>
<c:set var="zipCodeLookup" scope="page" value="true"/>
<c:set var="readOnlyAddress" scope="page" value="true"/>
<c:set var="isAddAPerson" value="false"></c:set>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>

<!-- set read only falgs based on user permissions -->
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).EDIT_ADDRESS.getName())">
  <c:set var="readOnlyAddress" scope="page" value="false"/>
</auth:authorize>
<c:if test="${person.permanentAddress == null}">
  <auth:authorize  access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADD_ADDRESS.getName())">
    <c:set var="readOnlyAddress" scope="page" value="false"/>
  </auth:authorize>
</c:if>

<%-- Person Locked Check --%>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyAddress" scope="page" value="true"/>
</c:if>

<c:if test="${readOnlyAddress}">
  <c:set var="countryEditable" scope="page" value="false"/>
  <c:set var="zipCodeLookup" scope="page" value="false"/>
</c:if>

<script type="text/javascript">
  // Perform all page initialization
  function onLoadInit()
  {
  
  // Need to remove the following 2 lines when Residential Address will be back - Nixon - Work Item - 429521
		var x = document.getElementById("addressTypeId");
		//x.remove(1);
 // Removing Confidential Address as it will be updated from VISTA - Nixon - Need to change the index if Residential is plugged in. Work Item - 433899 
	   x.remove(4);
			var selected = document.getElementsByName("addressType");
	if (selected[0].selectedIndex == 0)
	{
		document.getElementById("addressTblId").disabled = true;
	}
   // Issue #459630 - Remove Check on Blur but keep it in Update
    //validatePostal(); 
		  
    updateCountryFields();
    updateAddressSiteOfChange();
    initPhoneSitesOfChange();
    initEmailSitesOfChange();
    setAddEmailFocus();
    setAddPhoneNumberFocus();
  
  
  	var checkBoxes = document.getElementsByName("selectedConfAddrCategories");
	var checkedAll = true;
  	for (var i=0; i < checkBoxes.length & checkedAll; i++)
  	{
		
		checkedAll = checkBoxes[i].checked;
		document.getElementById("confAddressType").checked = checkedAll;
	
  	}

	setTimeout(function(){
		var contentAreaLinkObj = document.getElementById("contentAreaLink"); //defect#493555 - added to set focus to the Message/Error contentAreaLink if the link is loaded to the page.
		
		if(contentAreaLinkObj == null ){//defect#493555 - added to set focus to the Message/Error contentAreaLink if the link is loaded to the page.
			document.getElementById("addressTypeId").focus();
		}
		else{
			contentAreaLinkObj.focus(); 
		}
		
	},1000);
    
  }
  
//Place focus on "Email Type" field when "Add Email Address" is clicked
  function setAddEmailFocus()
  {
	  if ('${demographicAddressesForm.addEmailType}' != '') {
		  var arr = '${demographicAddressesForm.addEmailType}';
		  var component = document.getElementsByName("emailType[" + arr + "]");
		  component[0].focus();
	  }
  }
  
  //Place focus on "Phone Type" field when "Add Phone Number" is clicked
  function setAddPhoneNumberFocus()
  {
	  if ('${demographicAddressesForm.addPhoneType}' != '') { 
		  var arr = '${demographicAddressesForm.addPhoneType}';
		  var component = document.getElementsByName("phoneType[" + arr + "]");
		  component[0].focus();
	  }
  }

  // Update the address site of change
  function updateAddressSiteOfChange()
  {
    updateSiteOfChange(demographicAddressesForm[0].elements["addrSourceOfUpdate"], '<c:out value="${addressVamcConstant}"/>',
        demographicAddressesForm[0].elements["siteOfUpdateEdit"], demographicAddressesForm[0].elements["siteOfUpdateEdit2"], '<c:out value="${hecFacilityConstant}"/>');
  }

  // Initialize the phone sites of change
  function initPhoneSitesOfChange()
  {
    for (i = 0; i < <c:out value="${phoneCount}"/>; i++)
    {
      updateSiteOfChange(eval("demographicAddressesForm[0].elements[\"phoneSourceOfUpdate" + i+"\"]"), '<c:out value="${phoneVamcConstant}"/>',
          eval("demographicAddressesForm[0].phoneSiteOfUpdateEdit" + i), eval("demographicAddressesForm[0].phoneSiteOfUpdateEdit2" + i),
          '<c:out value="${hecFacilityConstant}"/>');
    }
  }

  // Initialize the email sites of change
  function initEmailSitesOfChange()
  {
    for (i = 0; i < <c:out value="${emailCount}"/>; i++)
    {
      updateSiteOfChange(eval("demographicAddressesForm[0].emailSourceOfUpdate" + i), '<c:out value="${emailVamcConstant}"/>',
          eval("demographicAddressesForm[0].emailSiteOfUpdateEdit" + i), eval("demographicAddressesForm[0].emailSiteOfUpdateEdit2" + i),
          '<c:out value="${hecFacilityConstant}"/>');
    }
  }
  
   function loadAddress(addressType)
    {
      document.forms[1].addressType.value = addressType
      document.forms[1].submit();
  }
  
  
     function validatePostal(addressType)
      {
        document.getElementsByName("addressLine1")[0].onblur = function(){
    
	      checkPOBox();
        
        }
     }
     function checkPOBox()
     {
     	var country = document.getElementsByName("country")[0].value;
		var state = document.getElementsByName("state")[0].value;
		var pocheck = false;
		if (country == "USA")
		{
			if ((state=="AK") |(state=="ALASKA") | (state=="HI")|(state=="HAWAII") | (state=="GU")|(state=="GUAM") | (state == "VI") | (state == "VIRGIN ISLANDS") | (state == "AS") |(state=="AMERICAN SAMOA") | (state=="MP") | (state=="NORTHERN MARIANA ISLANDS") | (state == "PI"))
			{
				pocheck = true;
			}
		}
		if (country == "PHL")
			pocheck = true;
	
      	if( document.getElementsByName("addressType")[0].value == 'R'  & pocheck == false){
		var pattern = new RegExp('\\b(?:p\\.?\\o\\.?\\s*\\d+)\\b|\\b(post\\s*office\\s*\\d+)\\b|(box\\s*\\.?\\d+)|\\b(postal\\s*office\\s*\\d+)\\b|^(\\s*General\x20+Delivery\\s*)$','i');

			if (document.getElementsByName("addressLine1")[0].value.match(pattern)) {
				alert('<bean-el:message key="message.residentialAddressPOBox"/>');
				return false;
			}
			}
			var selected = document.getElementsByName("addressType");
	if (selected[0].selectedIndex == 0)
	{
	 if (document.getElementsByName("addressLine1")[0].value.length > 0)
	 {
	 	alert('Please select the Address Type');
	 	document.getElementsByName("addressType")[0].focus();
	 	return false;
	 } 
		
		}
			return true;
			
     }
     function onSubmitForm()
     {
     	if (!checkPOBox())
     		return false;
     	
     	var selected = document.getElementsByName("addressType");
		document.getElementById("selectedAddressType").value=selected[0].selectedIndex;
		
		/*if (selected[0].selectedIndex == 0)
		{
			alert('<bean-el:message key="message.addressTypeNotSelected"/>');
							selected[0].focus();
			return false;
		}*/
     
      /*var startDate = document.getElementsByName("startDate");
      
      if (startDate.length > 0)
      {
      	if (startDate[0].value == "")
      	{
      	 alert('<bean-el:message key="message.startDateRequired"/>');
      	 startDate[0].focus();
      	 return false;
      	}
      }
      
      var endDate = document.getElementsByName("endDate");
            if (endDate.length > 0)
      {
      	if (endDate[0].value == "")
      	{
      	 alert('<bean-el:message key="message.endDateRequired"/>');
      	 endDate[0].focus();
      	 return false;
      	}
      }
      */
     	var chkbox = document.getElementsByName("confAddrCategories");
     	chkbox.checked = false;
		//document.getElementById("addressTblId").disabled = false;
     	return true;
     }
</script>
<c:choose>
<c:when test="${displayRequiredFieldsIndicator}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/demographicAddresses" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<tr>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
  <%-- Permanent Address Section --%>
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
      <tr>
        <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td nowrap style="padding-left: 7px"><fw:label property="addAddressType" forId="addressTypeId"><bean-el:message key="label.addresses.addAddress"/></fw:label></td>
          <td width="55%" class="moduleValue">
	    <c:set var="addAddressText"><bean-el:message key="label.addresses.addAddress"/></c:set>
	    <html-el:select title="${addAddressText}" styleClass="moduleEdit"  styleId="addressTypeId" property="addressType" disabled="${readOnlyAddress}" onchange="javascript:loadAddress(this.value)">
	      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
	      <html-el:option value="R"><bean-el:message key="label.address.residentialaddress"/></html-el:option>
	      <html-el:option value="P"><bean-el:message key="label.address.permanentaddress"/></html-el:option>
	      <html-el:option value="C"><bean-el:message key="label.address.temporaryAddress"/></html-el:option>
	      <html-el:option value="CNF"><bean-el:message key="label.address.confidentialrddress"/></html-el:option>
	    </html-el:select>
<html-el:hidden  styleId="selectedAddressType" property="selectedAddressType"/>
	    
  	</td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px">
        <fw:link action="/demographicAddresses?methodName=goto508Notes">
            <bean-el:message key="text.508Notes"/>
        </fw:link>
        </td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <td nowrap class="moduleBlueLink" style="padding: 1px 8px 1px 8px"><fw:link action="/demographicAddressesHistory?methodName=DISPLAY&amp;history=viewHistoricalAddresses"><bean-el:message
            key="text.viewHistoricalAddresses"/></fw:link></td>
      </tr>
    </table>
  </td>
</tr>
<tr>
<td>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation" >
<tr>
<td>
<table width="100%" border="0" cellspacing="0" cellpadding="0" id="addressTblId">

<tr>
  <td colspan="2">
    <%@ include file="/tiles/common/instructionalText.jsp" %>
  </td>
</tr>
<tr>
  <td colspan="2" style="padding-top: 10px">
    <%@ include file="/tiles/common/addressForm.jsp" %>
      </td>
</tr>

<!-- {RR} 383296 - Residential Address Changes -->
<c:if test="${vAddressType =='P'}">
<tr>
  <td width="45%" class="moduleLabel"><fw:label property="badAddressReason" forId="txtBadAddressReason"><bean-el:message key="label.addresses.badAddressReason"/>:</fw:label></td>
  <td width="55%" class="moduleValue">
    <c:set var="badAddressReasonText">
    <bean-el:message key="label.addresses.badAddressReason"/>
    </c:set>
    <html-el:select title="${badAddressReasonText}" styleClass="moduleEdit" styleId="txtBadAddressReason" property="permBadAddressReason" disabled="${readOnlyAddress}">
      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.UIBadAddressReason" property="code" labelProperty="code"/>
    </html-el:select>
  </td>
</tr>
</c:if>
<tr>
<td colspan="2">
</td>
</tr>
<tr>
<td colspan="2">
</td>
</tr>
<tr>
  <td width="45%" class="moduleLabel"><fw:label property="permAddrSourceOfUpdate" forId="addrSourceOfUpdate"><bean-el:message key="label.addresses.sourceOfUpdate"/>:</fw:label></td>
  <td width="55%" class="moduleValue">
    <c:set var="sourceOfChangeText"><bean-el:message key="label.addresses.sourceOfUpdate"/></c:set>
    <html-el:select title="${sourceOfChangeText}" styleId="addrSourceOfUpdate" onchange="updateAddressSiteOfChange()" styleClass="moduleEdit" property="permAddrSourceOfUpdate" disabled="${readOnlyAddress}">
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.AddressChangeSource" property="code" labelProperty="code"/>
    </html-el:select>
  </td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label property="permAddrSiteOfUpdate" forId="siteOfUpdateEdit"><bean-el:message key="label.addresses.siteOfUpdate"/>:</fw:label></td>
  <td class="moduleValue">
    <c:set var="siteOfChangeText"><bean-el:message key="label.addresses.siteOfUpdate"/></c:set>
    <html-el:select title="${siteOfChangeText}" styleId="siteOfUpdateEdit" styleClass="moduleEdit" property="permAddrSiteOfUpdate" disabled="${readOnlyAddress}">
      <esrcore:options collection="gov.va.med.esr.ui.common.beans.VAFacility" property="code" labelProperty="siteNumberAndName"/>
    </html-el:select>
    <html-el:hidden name="demographicAddressesForm" styleId="siteOfUpdateEdit2" property="permAddrSiteOfUpdate"></html-el:hidden>
  </td>
</tr>



<!-- {RR} Task#294726 - Start and End Dates for Temporary and Confidential Address types -->
<c:if test="${vAddressType=='C' || vAddressType=='CNF'}">
	<tr>
	<td id="startDateLabel" class="moduleLabel">
	    <fw:label property="startDate"  required="${requiredFlag}"  forId="idStartDate"><bean-el:message key="label.addresses.startDate" />:</fw:label></td>
	<td id="startDateEdit"  class="moduleValue">
	 <c:set var="startDate"><bean-el:message key="label.addresses.startDate"/></c:set>
		<html-el:text title="${requiredText}${startDate} ${mmddyyyyText}" styleId="startDateEdit" styleClass="moduleEdit" property="startDate" size="25" maxlength="10" disabled="${readOnlyAddress}"/>
		&nbsp;<bean-el:message key="label.dateFormatmmddyyyy"/>
		<!-- esrcore:displayValue name="demographicAddressesForm" property="startDate" / -->
	</td>
	</tr>
	<tr>
	<td id="endDateLabel" class="moduleLabel">
	    <fw:label property="endDate" forId="idEndDate"><bean-el:message key="label.addresses.endDate" />:</fw:label></td>
	<td id="endDateEdit" class="moduleValue">
    <c:set var="endDate"><bean-el:message key="label.addresses.endDate"/></c:set>
		<html-el:text title="${endDate} ${mmddyyyyText}" styleId="endDateEdit" styleClass="moduleEdit" property="endDate" size="25" maxlength="10" disabled="${readOnlyAddress}"/>
		&nbsp;<bean-el:message key="label.dateFormatmmddyyyy"/>
		<!-- esrcore:displayValue name="demographicAddressesForm" property="endDate" / -->
	</td>
	</tr>
</c:if>

<!-- {RR} Task#294726 - Only Confidential Address allow view/edit correspondece types -->
<c:if test="${vAddressType=='CNF'}">
    <esrcore:setLookup var="confidentialAddressCateoryList" className="gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType" />
    <tr>
    	<td class="moduleLabel" style="vertical-align: top">
    		<fw:label required="true" property="confAddrCategories" forId="confAddrCategoriesId"><bean-el:message key="label.addresses.category" />:</fw:label></td>
    	<td class="moduleValue" colspan="2">
    	  <table border="0" cellpadding="0" cellspacing="0">
    	  	<c:set var="confAddrCategoriesTxt"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.addresses.category"/>&nbsp;<bean-el:message key="label.addresses.category" /></c:set>
      	    <tr>
      	    <td>
      	    <!--html-el:multibox title="${confAddrCategoriesTxt}" styleId="confAddrCategoriesId" property="confAddrCategories" value="${ALL}" onclick="checkAll(this)" /-->
      	    <input title="${confAddrCategoriesTxt}" type="checkbox" name="confAddressType" id="confAddressType" onclick="checkAll(this);"/>
      	    </td>
      	    <td colspan="2" class="moduleValue"><!--bean-el:message key="label.addresses.category" /-->All</td>
      	    </tr>
    	    <c:forEach var="item" items="${confidentialAddressCateoryList}">
    	   		<c:set var="selectedConfAddrCategoriesArray"><bean-el:message key="label.required" />,&nbsp;<bean-el:message key="label.addresses.category"/>&nbsp;<c:out value="${item.description}" /></c:set>
				<tr><td width="1%">&nbsp;&nbsp;</td><td><html-el:multibox title="${selectedConfAddrCategoriesArray}" property="selectedConfAddrCategories" value="${item.code}" />
				    </td><td class="moduleValue" width="99%"><c:out value="${item.description}" /></td></tr>
	    	</c:forEach>
	  	  </table>
    	</td>
    </tr>
</c:if>

<!-- Task #428816 - CASS Certified Type / Date -->
<tr>
  <td width="45%" class="moduleLabel"><fw:label property="cassCertifiedType" forId="txtcassCertifiedType"><bean-el:message key="label.addresses.cassCertifiedType"/>:</fw:label></td>
  <td width="55%" class="moduleValue">
    <c:set var="cassCertifiedTypeText">
    <bean-el:message key="label.addresses.cassCertifiedType"/>
    </c:set>
    ${demographicAddressesForm.selectedCassCertifiedType}
  </td>
</tr>

<tr>
  <c:set var="cassCertifiedDateText"><bean-el:message key="label.addresses.cassCertifiedDate"/></c:set>
  <td class="moduleLabel"><bean-el:message key="label.addresses.cassCertifiedDate"/>:</td>
  <td title="<c:out value="${lastUpdateText}"/>" class="moduleValue" valign="top" nowrap><esrcore:displayValue name="demographicAddressesForm" property="cassCertifiedDate" nullText=""/>
  </td>
</tr>

<tr>
  <c:set var="lastUpdateText"><bean-el:message key="label.addresses.lastUpdate"/></c:set>
  <td class="moduleLabel"><bean-el:message key="label.addresses.lastUpdate"/>:</td>
  <td title="<c:out value="${lastUpdateText}"/>" class="moduleValue" valign="top" nowrap><esrcore:displayValue name="demographicAddressesForm" property="permAddrLastUpdate" nullText=""/>
    <html-el:hidden name="demographicAddressesForm" property="permAddrLastUpdate"></html-el:hidden>
    <html-el:hidden name="demographicAddressesForm" property="permAddrCurrent"></html-el:hidden>
    <html-el:hidden name="demographicAddressesForm" property="confAddrCurrent"></html-el:hidden>
    <html-el:hidden name="demographicAddressesForm" property="tempAddrCurrent"></html-el:hidden>
  </td>
</tr>
</table>
</td>
</tr>


  <%-- Phone Numbers Section --%>
<tr>
  <td colspan="2" style="padding: 10px 0 7px 0">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
      <tr>
        <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td style="padding-left: 7px" nowrap><bean-el:message key="label.addresses.phoneNumbersHeader"/></td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <c:if test="${not readOnlyAddress}">
          <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
          <td><html-el:submit property="methodName" style="width:110; vertical-align: top;" styleClass="buttonText"><bean:message key="button.addPhoneNumber"/></html-el:submit></td>
          <td style="padding-right: 5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
        </c:if>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td colspan="2">
    <table summary="List of Phone Numbers for the Person" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
      <c:choose>
        <c:when test="${demographicAddressesForm.noPhoneData == true}">
          <tr>
            <td class="moduleLabel" style="padding:10px 0 10px 10px; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <thead>
          <tr>
            <c:set var="phoneTypeText"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.type"/></c:set>
            <c:set var="phoneNumberText"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.number"/></c:set>
            <c:set var="phoneSourceofChangeText"><bean-el:message key="label.addresses.sourceOfUpdate"/></c:set>
            <c:set var="phoneSiteOfChangeText"><bean-el:message key="label.addresses.siteOfUpdate"/></c:set>
            <c:set var="phoneLastUpdateText"><bean-el:message key="label.addresses.lastUpdate"/></c:set>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b>#</b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="phoneType"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.type"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="phoneNumber"><bean-el:message key="label.addresses.phone"/> <bean-el:message key="label.addresses.number"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" style="padding:5px"><b><fw:label property="phoneSourceOfUpdate"><bean-el:message key="label.addresses.sourceOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="phoneSiteOfUpdate"><bean-el:message key="label.addresses.siteOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><bean-el:message key="label.addresses.lastUpdate"/></b></th>
            <th scope="col" class="darkValue" valign="bottom" width="100%"><img alt="" src="../images/spacer.gif" width="1" height="1"/></th>
          </tr>
          </thead>

          <c:set var="rowColor" value="darkValue"/>
          <c:forEach var="serviceEpisode" items="${demographicAddressesForm.phoneIdList}" varStatus="status">
            <c:set var="counter" value="${status.count - 1}"/>
            <html-el:hidden property="phoneId[${counter}]"/>

            <c:choose>
              <c:when test="${rowColor == 'darkValue'}">
                <c:set var="rowColor" value="value"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="darkValue"/>
              </c:otherwise>
            </c:choose>

            <tbody>
            <tr>
              <td scope="row" title="<c:out value="${status.count}"/>." style="padding:5px" class="<c:out value="${rowColor}"/>"><c:out value="${status.count}"/>.</td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>
                <fw:label property="phoneType[${counter}]" forId="phoneType${counter}"><span style="display:none">phoneTypeId</span></fw:label>
                <html-el:select title="${phoneTypeText} ${status.count}" styleClass="darkValue" styleId="phoneType${counter}" property="phoneType[${counter}]" disabled="${readOnlyAddress}">
                  <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
                  <esrcore:options collection="gov.va.med.esr.ui.common.beans.AddressPhoneType" property="code" labelProperty="description"/>
                </html-el:select>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="phoneNumber[${counter}]" forId="phoneNumber${counter}"><span style="display:none">phoneNumberId</span></fw:label>
                <html-el:text title="${phoneNumberText} ${status.count}" property="phoneNumber[${counter}]" styleClass="darkValue" styleId="phoneNumber${counter}" size="20" maxlength="20" readonly="${readOnlyAddress}"
                              onkeypress="return validatePhone(event)" onchange="formatPhoneNumber(this)"/>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="phoneSourceOfUpdate[${counter}]" forId="phoneSourceOfUpdate${counter}"><span style="display:none">phoneSourceOfChangeId</span></fw:label>                
                <html-el:select title="${phoneSourceofChangeText} ${status.count}" property="phoneSourceOfUpdate[${counter}]" styleClass="darkValue" disabled="${readOnlyAddress}" styleId="phoneSourceOfUpdate${counter}"
                                onchange="updateSiteOfChange(demographicAddressesForm[0].phoneSourceOfUpdate${counter}, '${phoneVamcConstant}', phoneSiteOfUpdateEdit${counter}, phoneSiteOfUpdateEdit2${counter}, '${hecFacilityConstant}')">
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.PhoneSourceOfChange" property="code" labelProperty="description"/>
                </html-el:select>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="phoneSiteOfUpdate[${counter}]" forId="phoneSiteOfUpdateEdit${counter}"><span style="display:none">phoneSiteOfChangeEditId</span></fw:label>                
                <html-el:select title="${phoneSiteOfChangeText} ${status.count}" styleId="phoneSiteOfUpdateEdit${counter}" styleClass="darkValue" property="phoneSiteOfUpdate[${counter}]" disabled="${readOnlyAddress}">
                  <esrcore:options collection="gov.va.med.esr.ui.common.beans.VAFacility" property="code" labelProperty="siteNumberAndName"/>
                </html-el:select>
                <fw:label property="phoneSiteOfUpdate[${counter}]" forId="phoneSiteOfUpdateEdit2${counter}"><span style="display:none">phoneSiteOfChangeEditId2Id</span></fw:label>                
                <html-el:hidden name="demographicAddressesForm" styleId="phoneSiteOfUpdateEdit2${counter}" property="phoneSiteOfUpdate[${counter}]"></html-el:hidden>
              </td>
              <td title="<c:out value="${phoneLastUpdateText} ${status.count}"/>" style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>
                <c:out value="${demographicAddressesForm.phoneLastUpdateList[counter]}"/>                
                <html-el:hidden name="demographicAddressesForm" property="phoneLastUpdate[${counter}]"/>
              </td>
              <td class="<c:out value="${rowColor}"/>" width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
            </tr>
            </tbody>
          </c:forEach>
        </c:otherwise>
      </c:choose>
    </table>
  </td>
</tr>

  <%-- Email Addresses Section --%>
<tr>
  <td colspan="2" style="padding: 10px 0 7px 0">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
      <tr>
        <td class="moduleBrownBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
        <td style="padding-left: 7px" nowrap><bean-el:message key="label.addresses.emailAddressHeader"/></td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <c:if test="${not readOnlyAddress}">
          <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
          <td><html-el:submit property="methodName" style="width:110; vertical-align: top;" styleClass="buttonText"><bean:message key="button.addEmailAddress"/></html-el:submit></td>
          <td style="padding-right: 5px"><img alt=""  src="../images/buttonEndRight.gif"/></td>
        </c:if>
      </tr>
    </table>
  </td>
</tr>

<tr>
  <td colspan="2">
    <table summary="List of Email Addresses for the Person" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
      <c:choose>
        <c:when test="${demographicAddressesForm.noEmailData == true}">
          <tr>
            <td class="moduleLabel" style="padding:10px 0 10px 10px; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <thead>
          <tr>
            <c:set var="emailTypeText"><bean-el:message key="label.addresses.email"/> <bean-el:message key="label.addresses.type"/></c:set>
            <c:set var="emailAddressText"><bean-el:message key="label.addresses.email"/> <bean-el:message key="label.addresses.address"/></c:set>
            <c:set var="emailSourceOfChangeText"><bean-el:message key="label.addresses.sourceOfUpdate"/></c:set>
            <c:set var="emailSiteOfChangeText"><bean-el:message key="label.addresses.siteOfUpdate"/></c:set>
            <c:set var="emailLastUpdateText"><bean-el:message key="label.addresses.lastUpdate"/></c:set>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b>#</b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="emailType" forId="txtEmailType"><bean-el:message key="label.addresses.email"/>&nbsp<bean-el:message key="label.addresses.type"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="emailAddress" forId="txtEmailAddress"><bean-el:message key="label.addresses.email"/>&nbsp<bean-el:message key="label.addresses.address"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" style="padding:5px"><b><fw:label property="emailSourceOfUpdate" forId="txtEmailSourceOfUpdate"><bean-el:message key="label.addresses.sourceOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><fw:label property="emailSiteOfUpdate" forId="txtEmailSiteOfUpdate"><bean-el:message key="label.addresses.siteOfUpdate"/></fw:label></b></th>
            <th scope="col" class="darkValue" valign="bottom" nowrap style="padding:5px"><b><bean-el:message key="label.addresses.lastUpdate"/></b></th>
            <th scope="col" class="darkValue" valign="bottom" width="100%"><img alt="" src="../images/spacer.gif" width="1" height="1"/></th>
          </tr>
          </thead>

          <c:set var="rowColor" value="darkValue"/>
          <c:forEach var="serviceEpisode" items="${demographicAddressesForm.emailIdList}" varStatus="status">
            <c:set var="counter" value="${status.count - 1}"/>
            <html-el:hidden property="emailId[${counter}]"/>

            <c:choose>
              <c:when test="${rowColor == 'darkValue'}">
                <c:set var="rowColor" value="value"/>
              </c:when>
              <c:otherwise>
                <c:set var="rowColor" value="darkValue"/>
              </c:otherwise>
            </c:choose>

            <tbody>
            <tr>
              <td scope="row" title="<c:out value="${status.count}"/>." style="padding:5px" class="<c:out value="${rowColor}"/>"><c:out value="${status.count}"/>.</td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>                
                 <fw:label property="emailType[${counter}]" forId="emailType${counter}"><span style="display:none">emailTypeId</span></fw:label>
                <html-el:select title="${emailTypeText} ${status.count}" styleClass="darkValue" styleId="emailType${counter}" property="emailType[${counter}]" disabled="${readOnlyAddress}">
                  <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.EmailType" property="code" labelProperty="description"/>
                </html-el:select>
                <html-el:hidden property="emailId[${counter}]"/>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="emailAddress[${counter}]" forId="emailAddress${counter}"><span style="display:none">emailAddressId</span></fw:label>
                <html-el:text title="${emailAddressText} ${status.count}" property="emailAddress[${counter}]" styleClass="darkValue" styleId="emailAddress${counter}" size="36" maxlength="80" readonly="${readOnlyAddress}"/>
              </td>

              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="emailSourceOfUpdate[${counter}]" forId="emailSourceOfUpdate${counter}"><span style="display:none">emailSourceOfChangeId</span></fw:label>                
                <html-el:select title="${emailSourceOfChangeText} ${status.count}" property="emailSourceOfUpdate[${counter}]" disabled="${readOnlyAddress}" styleClass="darkValue" styleId="emailSourceOfUpdate${counter}"
                                onchange="updateSiteOfChange(demographicAddressesForm[0].emailSourceOfUpdate${counter}, '${emailVamcConstant}', emailSiteOfUpdateEdit${counter}, emailSiteOfUpdateEdit2${counter}, '${hecFacilityConstant}')">
                  <esrcore:options collection="gov.va.med.esr.common.model.lookup.EmailSourceOfChange" property="code" labelProperty="description"/>
                </html-el:select>
              </td>
              <td style="padding:5px" class="<c:out value="${rowColor}"/>">
                <fw:label property="emailSiteOfUpdate[${counter}]" forId="emailSiteOfUpdateEdit${counter}"><span style="display:none">emailSiteOfChangeEditId</span></fw:label>                
                <html-el:select title="${emailSiteOfChangeText} ${status.count}" styleId="emailSiteOfUpdateEdit${counter}" styleClass="darkValue" property="emailSiteOfUpdate[${counter}]" disabled="${readOnlyAddress}">
                  <esrcore:options collection="gov.va.med.esr.ui.common.beans.VAFacility" property="code" labelProperty="siteNumberAndName"/>
                </html-el:select>
                <fw:label property="emailSiteOfUpdate[${counter}]" forId="emailSiteOfUpdateEdit2${counter}"><span style="display:none">emailSiteOfChangeEditId2Id</span></fw:label>                
                <html-el:hidden name="demographicAddressesForm" styleId="emailSiteOfUpdateEdit2${counter}" property="emailSiteOfUpdate[${counter}]"></html-el:hidden>
              </td>
              <td title="<c:out value="${emailLastUpdateText} ${status.count}"/>" style="padding:5px" class="<c:out value="${rowColor}"/>" nowrap>
                <c:out value="${demographicAddressesForm.emailLastUpdateList[counter]}"/>
                <html-el:hidden name="demographicAddressesForm" property="emailLastUpdate[${counter}]"/>
              </td>
              <td class="<c:out value="${rowColor}"/>" width="100%"><img alt=""  src="../images/spacer.gif" width="1" height="1"/></td>
            </tr>
            </tbody>
          </c:forEach>
        </c:otherwise>
      </c:choose>
    </table>
  </td>
</tr>
<tr>
  <td colspan=2 height="50">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
      <tr>
        <c:choose>
          <c:when test="${readOnlyAddress}">
            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.cancel"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="50%"><img alt=""  src="../images/spacer.gif"/></td>
          </c:when>
          <c:otherwise>
            <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText" onclick="return onSubmitForm();"><bean:message key="button.update"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.reset"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
            <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
            <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean:message key="button.cancel"/></html-el:submit></td>
            <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
            <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
          </c:otherwise>
        </c:choose>
      </tr>
    </table>
  </td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>


    </td>
  </tr>
  <html-el:hidden name="demographicAddressesForm" property="addAPerson"/>
</html-el:form>

 <html-el:form action="/demographicAddresses" method="GET">
  <input type="hidden" name="methodName" value="Addresses"/>
  <input type="hidden" name="addressType" value="C"/>
  
  </html-el:form>
</table>
