<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>

<%@ page import="gov.va.med.esr.common.model.lookup.AssociationType" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="addCode"><%=Capability.ADD_CONTACT_EXCLUDE_NEXT_OF_KIN.getName()%></c:set>
<c:set var="editCode"><%=Capability.EDIT_CONTACT_EXCLUDE_NEXT_OF_KIN.getName()%></c:set>
<c:set var="deleteCode"><%=Capability.DELETE_CONTACT_EXCLUDE_NEXT_OF_KIN.getName()%></c:set>
<c:set var="viewCode"><%=Capability.VIEW_CONTACT.getName()%></c:set>
<c:set var="editPermission" scope="page" value="false"/>
<c:set var="addOrUpdatePermission" scope="page" value="false"/>
<auth:authorize access="hasAnyRole(${editCode})">
  <c:set var="editPermission" scope="page" value="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(${addCode},${editCode})">
  <c:set var="addOrUpdatePermission" scope="page" value="true"/>
</auth:authorize>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="editPermission" scope="page" value="false"/>
  <c:set var="addOrUpdatePermission" scope="page" value="false"/>
</c:if>

<c:set var="addAPersonKey" value="addAPerson"/>
<c:set var="addAPerson" value="${AppData[addAPersonKey]}" />

<script language="JavaScript">
<!--
function validateForm(){

<c:choose>
		<c:when test="${addAPerson}">	
  var oRows = document.getElementById('assoTable').getElementsByTagName('tr');
  
  var iRowCount = oRows.length;
  var i=0;
  
  if(iRowCount <5){
	return true;
  }
  else{
	    alert("The maximum number of associate allowed is 5");
		return false;
  }
  </c:when>
    <c:otherwise>
    return true;
    	</c:otherwise>
</c:choose>
}

-->
</script>


<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/addAssociation" method="post" onSubmit="return validateForm()" >
  <%@ include file="/admin/csrfgentoken.jsp" %>
<tr>
<td width="100%">
<table width="100%" border="0" cellpadding="0" cellspacing="0">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
      <tr>
        <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
        <td nowrap style="padding-left: 7"><bean-el:message key="label.association.associates"/></td>
        <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
        <c:if test="${addOrUpdatePermission == true}">
          <td width="50%"><img alt=""  src="../images/spacer.gif" width="1" height="1" border="0"/></td>
          <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
          <td><html-el:submit property="methodName" 
          style="width:90; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.addAssociate"/></html-el:submit></td>
          <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
          <td><img alt=""  src="../images/spacer.gif" width="5"/></td>
        </c:if>
        <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
          <fw:link action="/associationHistory?methodName=DISPLAY&amp;history=viewHistoricalAssociates">
            <bean-el:message key="label.association.viewHistoricalAssociates"/>
          </fw:link>
        </td>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td>
    <table summary="List of Associates for the Person" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody">
      <tr><td class="darkValue" colspan="7"><img alt=""  src="../images/spacer.gif" height="5"/></td></tr>
      <thead>
      <tr>
        <td scope="col" width="1%" class="darkValue">&nbsp;</td>
        <th scope="col" width="20%" class="darkValue"><b><bean-el:message key="label.association.name"/></b></th>
        <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="label.contact.relationship"/></b></th>
        <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="label.association.role"/></b></th>
        <th scope="col" width="20%" class="darkValue"><b><bean-el:message key="label.address.address"/></b></th>
        <th scope="col" width="20%" class="darkValue"><b><bean-el:message key="history.title.phones"/></b></th>
        <td scope="col" width="1%" class="darkValue">&nbsp;</td>
      </tr>
	</thead>
      <c:set var="powerOfAttorney"><%=AssociationType.CODE_POWER_OF_ATTORNEY.getName()%></c:set>
      <c:set var="guardianVa"><%=AssociationType.CODE_GUARDIAN_VA.getName()%></c:set>
      <c:set var="guardianCivil"><%=AssociationType.CODE_GUARDIAN_CIVIL.getName()%></c:set>
	
	<tbody id="assoTable">
      <c:set var="rowColor" value="darkValue"/>
      <c:forEach var="association" items="${associations}">
        <c:choose>
          <c:when test="${rowColor == 'darkValue'}">
            <c:set var="rowColor" value="value"/>
          </c:when>
          <c:otherwise>
            <c:set var="rowColor" value="darkValue"/>
          </c:otherwise>
        </c:choose>
        <tr>
          <td class="<c:out value="${rowColor}"/>">&nbsp;</td>
          <td scope="row" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
            <c:set var="identifier" value="${association.entityKey.keyValueAsString}"/>
            <c:set var="role" value="${association.type.code}"/>

            <c:set var="name"><esrcore:displayValue name="association" property="representativeName"/></c:set>
            <c:if test="${not empty association.organizationName}">
              <c:choose>
                <c:when test="${not empty name}">
                  <c:set var="name"><c:out value="${name}"/> (<c:out value="${association.organizationName}"/>)</c:set>
                </c:when>
                <c:otherwise>
                  <c:set var="name"><c:out value="${association.organizationName}"/></c:set>
                </c:otherwise>
              </c:choose>
            </c:if>
            <c:choose>
              <c:when test="${editPermission && (role == powerOfAttorney || role == guardianVa || role == guardianCivil)}">
                <fw:link action="updateAssociation?methodName=DISPLAY" paramId="associateId" paramName="identifier"><c:out value="${name}"/></fw:link>
              </c:when>
              <c:otherwise>
                <c:out value="${name}"/>
              </c:otherwise>
            </c:choose>
          </td>
          <td valign="top" class="<c:out value="${rowColor}"/>">
            <c:if test="${not empty association.relationship}">
              <c:out value="${association.relationship}"/>
            </c:if>
          </td>
          <td valign="top" class="<c:out value="${rowColor}"/>">
            <c:if test="${not empty association.type.description}">
              <c:out value="${association.type.description}"/>
            </c:if>
          </td>
          <td valign="top" class="<c:out value="${rowColor}"/>">
            <esrcore:displayValue name="association" property="address"/>
          </td>
          <td valign="top" class="<c:out value="${rowColor}"/>">
            <c:if test="${not empty association.primaryPhone}">
              <bean-el:message key="label.contact.correspondencephonehome"/>: <esrcore:displayValue name="association" property="primaryPhone"/>
            </c:if>
            <c:if test="${(not empty association.primaryPhone) && (not empty association.alternatePhone)}"><br></c:if>
            <c:if test="${not empty association.alternatePhone}">
              <bean-el:message key="label.contact.correspondencephonework"/>: <esrcore:displayValue name="association" property="alternatePhone"/>
            </c:if>
          </td>
          <td class="<c:out value="${rowColor}"/>">&nbsp;</td>
        </tr>
      </c:forEach>
      </tbody>
      <tr><td class="darkValue" colspan="7"><img alt=""  src="../images/spacer.gif" height="5"/></td></tr>
    </table>
  </td>
</tr>
</table>
</td>
</tr>
</html-el:form>
</table>
