<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="canOverrideConditionsToSend" value="false"/>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).OVERRIDE_CONDITIONS_TO_SEND.getName())">
  <c:set var="canOverrideConditionsToSend" value="true"/>
</auth:authorize>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/commslog" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<html-el:hidden property="selectedCommsLogId" />
<html-el:hidden property="selectedCaseId" />
<html-el:hidden property="selectedFormNumber" />
<html-el:hidden property="remailInd" />

<c:set var="isPendingLetter" value="false"></c:set>
<c:if test="${ ( commsLogForm.selectedFormNumber == '742-650' ) || ( commsLogForm.selectedFormNumber == '742-651' ) || ( commsLogForm.selectedFormNumber == '742-652' ) || ( commsLogForm.selectedFormNumber == '742-652A' )}"> 
    <c:set var="isPendingLetter" value="true"></c:set>
</c:if>

  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="25" height="17"/></td>
                <td nowrap style="padding-left: 7">
                   <esrcore:displayValue name="commsLogForm" property="selectedFormNumber" nullText=""/> -
                   <esrcore:displayValue name="commsLogForm" property="selectedFormName" nullText=""/>
                 </td>
                 <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
            <table align="center" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
              <tr><td colspan="2">&nbsp;</td></tr>
              <tr>
                <td class="moduleLabel">&nbsp;</td>
                <c:if test="${commsLogForm.requiredFieldMissingInd == true}">
                <td class="moduleValue"><bean-el:message key="commsLog.requiredFieldMissing" /></td>
                </c:if>
                <c:if test="${commsLogForm.requiredFieldMissingInd == false}">
                <td class="moduleValue"><bean-el:message key="commsLog.rejectReasons" />:</td>
                </c:if>
              </tr>

              <tr>
                <td class="moduleValue">&nbsp;</td>
                <td class="moduleValue">
                  <ul>
                  <fw:messages id="error">
                    <bean-el:message key="errors.prefix" /><c:out value="${error}" /><bean-el:message key="errors.suffix" />
                  </fw:messages>
                  </ul>
                </td>
              </tr>

              <c:if test="${commsLogForm.requiredFieldMissingInd == false}">
              <tr>
                <td class="moduleLabel">&nbsp;</td>                
                 <c:choose>
                    <c:when test="${isPendingLetter}">
                		 <td class="moduleLabel">&nbsp;</td> 
                    </c:when> 
                    <c:otherwise>                       
                <td class="moduleValue">
                 <fw:label forId="overrideConditionId" property="override">Do you want to override this condition and send the letter?</fw:label>
                  <html-el:checkbox title="Do you want to override this condition and send the letter" property="override" disabled="${not canOverrideConditionsToSend}" styleId="overrideConditionId" />Yes</td>
                </td>
                    </c:otherwise>
                </c:choose>
              </tr>

              <tr>
                <td width="10%" class="moduleLabel" valign="top"><fw:label property="newComment" forId="txtNewComment">Comments:</fw:label></td>
                <td width="90%" class="moduleValue"><textarea title="Comments" wrap="hard" name="newComment" id="txtNewComment" cols="90" rows="8"/><c:out value="${commsLogForm.newComment}"/></textarea></td>
              </tr>

              <tr>
                <td colspan="2" class="moduleValueButton">
                  <table width="100%" border="0" align="center" cellspacing="0" cellpadding="0" role="presentation">
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                      <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.update"/></html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
	                      <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancelRejection"/></html-el:submit></td>
                      <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
                    </tr>
                  </table>
                </td>
              </tr>
              </c:if>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</html-el:form>
</table>
