<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/displaytag" prefix="display" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="canMailReMail" value="false"/>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).MANUAL_MAIL_REMAIL_LETTER.getName())">
  <c:set var="canMailReMail" value="true"/>
</auth:authorize>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<tr>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
      <tr>
        <td class="moduleBlueBox">&nbsp;</td>
        <td width="80%" class="moduleHeadline">Letter Mailed on Behalf of Veteran</td>
        <td width="18%" class="moduleHeadline">&nbsp;</td>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td>
    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
      <c:choose>
        <c:when test="${vlhlist==null ||vlhlist.valueListInfo==null ||vlhlist.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="commsLog" style="border-width:0px;">
                <table id="commsLogResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="commsLogTableId" value="vlhlist" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                  <vlh:addParam name="checkboxName" value="Select" temp="false"/>
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagefutureEGTSettingsTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
                        <table summary="List of Letters Mailed on Behalf of Veteran" rules="all" class="TableDisplay">
                          <tr>
                            <vlh:row bean="commsLog">
                              <vlh:column titleKey="table.statusDate" property="latestMailingStatus.modifiedOn" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <vlh:attribute name="scope">row</vlh:attribute>
                                <esrcore:displayValue name="commsLog" property="latestMailingStatus.modifiedOn" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.status" property="latestMailingStatus.mailingStatus.description" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <esrcore:displayValue name="commsLog" property="latestMailingStatus.mailingStatus.description" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.name" property="templateName" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <a href="/esr/comms/commslog.do?methodName=Communication Detail&selectedCommsLogId=<c:out value="${commsLog.entityKey.keyValue}"/>">
									<esrcore:displayValue name="commsLog" property="formNumber" nullText=""/> -									
									<esrcore:displayValue name="commsLog" property="templateName" nullText=""/>
								</a>
                              </vlh:column>

                              <vlh:column titleKey="table.type" property="letterType.description" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <esrcore:displayValue name="commsLog" property="letterType.description" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.recipient" property="recipient" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <esrcore:displayValue name="commsLog" property="recipient" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.remail" property="noProperty" attributes="align=\"left\" scope='col'" default="">
                                <c:choose>
                                  <c:when test="${canMailReMail == true && ( commsLog.eligibleForRemail || commsLog.latestMailingStatus.mailingStatus.description == 'Sent to Print Vendor') }">
                                    <a href="/esr/comms/commslog.do?methodName=remail&selectedCommsLogId=<c:out value="${commsLog.entityKey.keyValue}"/>"> Mail</a>
                                  </c:when>
                                  <c:otherwise>&nbsp;</c:otherwise>
                                </c:choose>
                              </vlh:column>

                            </vlh:row>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </vlh:root>
                </table>
              </div>
            </td>
          </tr>
        </c:otherwise>
      </c:choose>

    </table>
    <!-- module shell table body-->
  </td>
</tr>

</table>
<!-- module shell table  -->
</td>
</tr>
</table>
<!-- module shell -->
