<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Permissions --%>
<c:set var="tabUserProfile" value="false"/>
<c:set var="tabRoles" value="false"/>
<c:set var="tabCapabilitySets" value="false"/>

<%-- update permissions based assigned Capabilities --%>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).MANAGE_USER_PROFILES)">
  <c:set var="tabUserProfile" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).MANAGE_ROLES)">
  <c:set var="tabRoles" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).MANAGE_CAPABILITY_SETS)">
  <c:set var="tabCapabilitySets" value ="true"/>
</auth:authorize>

<%-- Alt Text --%>
<c:set var="userProfilesText" scope="page"><bean-el:message key="label.userProfiles"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="rolesText" scope="page"><bean-el:message key="label.roles"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="capabilitySetsText" scope="page"><bean-el:message key="label.capabilitySets"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="selectedTabText" scope="page"><bean-el:message key="label.selectedTab"/>,&nbsp;</c:set>

<table cellSpacing="0" cellPadding="0" border="0">
  <tr valign="bottom">
    <c:if test="${tabUserProfile == true}">
    <c:choose>
    <c:when test="${tabName == 'userProfile'}">
      <c:set var="userProfilesText" scope="page" value="${selectedTabText}${userProfilesText}"/>
      <td><html-el:link forward="searchUserProfile.display"><html-el:img alt="${userProfilesText}" src="/esr/images/tabs_userProfiles_on.gif" width="123" height="23" border="0"/></html-el:link></td>
    </c:when>
    <c:otherwise>
      <td style="border-bottom: 1px solid #000000;"><html-el:link styleClass="tabLink" forward="searchUserProfile.display"><html-el:img alt="${userProfilesText}" src="/esr/images/tabs_userProfiles_off.gif" width="123" height="23" border="0"/></html-el:link></td>
    </c:otherwise>
    </c:choose>
    </c:if>

    <c:if test="${tabRoles == true}">
    <c:choose>
    <c:when test="${tabName == 'roles'}">
      <c:set var="rolesText" scope="page" value="${selectedTabText}${rolesText}"/>
      <td><html-el:link forward="viewRoles.display"><html-el:img alt="${rolesText}" src="/esr/images/tabs_roles_on.gif" width="123" height="23" border="0"/></html-el:link></td>
    </c:when>
    <c:otherwise>
      <td style="border-bottom: 1px solid #000000;"><html-el:link styleClass="tabLink" forward="viewRoles.display"><html-el:img alt="${rolesText}" src="/esr/images/tabs_roles_off.gif" width="123" height="23" border="0"/></html-el:link></td>
    </c:otherwise>
    </c:choose>
    </c:if>

    <c:if test="${tabCapabilitySets == true}">
    <c:choose>
    <c:when test="${tabName == 'capabilitySets'}">
      <c:set var="capabilitySetsText" scope="page" value="${selectedTabText}${capabilitySetsText}"/>
      <td><html-el:link forward="viewCapabilitySets.display"><html-el:img alt="${capabilitySetsText}" src="/esr/images/tabs_capabilitySets_on.gif" width="123" height="23" border="0"/></html-el:link></td>
    </c:when>
    <c:otherwise>
      <td style="border-bottom: 1px solid #000000;"><html-el:link styleClass="tabLink" forward="viewCapabilitySets.display"><html-el:img alt="${capabilitySetsText}" src="/esr/images/tabs_capabilitySets_off.gif" width="123" height="23" border="0"/></html-el:link></td>
    </c:otherwise>
    </c:choose>
    </c:if>
    <td width="100%" style="border-bottom: 1px solid #000000;">&nbsp;</td>
  </tr>
</table>
