<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="assignedText" scope="page"><bean-el:message key="label.assigned"/></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>

<script language="javascript">
function deleteSetError()
{
  var errorMessage = "This set is assigned to a User/Role and can not be deleted.";
  alert(errorMessage);
  return false;
}

function deleteSetConfirm()
{
  var confirmMessage = "Do you really want to delete this Capability Set?";
  return confirm(confirmMessage);
}

function confirmSetUpdate()
{
  var message = "This Capability Set is assigned to a User/Role. Do you still want to edit?";
  return confirm(message);
}
function expandAllSets()
{
  expandCollapseLists("setList", "setListImage", "setListHiddenId", null);
  document.getElementById("collapseAllLink").style.display="block";
  document.getElementById("expandAllLink").style.display="none";
  return false;
}

function collapseAllSets()
{
  expandCollapseLists("setList", "setListImage", "setListHiddenId", null);
  document.getElementById("collapseAllLink").style.display="none";
  document.getElementById("expandAllLink").style.display="block";
  return false;
}

</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
  <html:form action="/editPlanName" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  
  <%-- Permissions --%>
  
  <c:set var ="edit" value="false"/>
  <c:set var="readOnlyUser" value="true"/>
  <c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
  
  <c:set var="addCode"><%=Capability.ADD_HEALTH_BENEFITS_PLAN_INFORMATION.getName()%></c:set>
  <c:set var="editCode"><%=Capability.EDIT_HEALTH_BENEFITS_PLAN_INFORMATION.getName()%></c:set>
  <c:set var="viewCode"><%=Capability.VIEW_HEALTH_BENEFITS_PLAN_INFORMATION.getName()%></c:set>

  <c:set var="addPermission" value="false"/>
  <c:set var="editPermission" value="false"/>
  <c:set var="viewPermission" value="false"/>
  <c:set var="viewEditPermission" value="false"/>
  
  <auth:authorize access="hasAnyRole(${addCode})">
    <c:set var="addPermission" value="true"/>
  </auth:authorize>
  <auth:authorize access="hasAnyRole(${editCode})">
    <c:set var="editPermission" value="true"/>
  </auth:authorize>
    <auth:authorize access="hasAnyRole(${viewCode},${editCode})">
    <c:set var="viewPermission" value="true"/>
  </auth:authorize>
  <auth:authorize access="hasAnyRole(${editCode},${addCode})">
    <c:set var="viewEditPermission" value="true"/>
  </auth:authorize>
  
  <auth:authorize access="hasAnyRole(${editCode})">
    <c:set var="readOnlyUser" value="false"/>
  </auth:authorize>  
 <auth:authorize access="hasAnyRole(${addCode})">
    <c:set var="edit" value="true"/>
  </auth:authorize>
 <%-- need to work on edit and add setting, so both may share one jsp page --%>
  
  <%-- 
  <c:out value="${addPermission}"/>
  <c:out value="${editPermission}"/>
  <c:out value="${viewPermission}"/>
  <c:out value="${readOnlyUser}"/>
 --%>
 
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
      
       <tr>
        <td>
        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
          <tr>
            <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
            <td nowrap style="padding-left: 7">
                  <bean-el:message key="label.activeHbps"/>
            </td>

            <td width="85%"><img alt=""  src="../images/spacer.gif"></td>

                <c:if test="${addPermission}">
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:120; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.addPlanName"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                </c:if>   
          </tr>
        </table>
       </td>
      </tr>

       <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
              <tr>
                <td style="padding:10 10 10 10">
                  <table summary="Table for Active Health Benefits Plan" width="100%" border="0" cellspacing="0" cellpadding="0" >
                    <thead>
                    <tr>
                      <th scope="col" width="35%" class="darkValue" valign="bottom" nowrap style="text-align: left;padding:5 5 5 5"><b><bean-el:message key="label.name"/></b></th>
                      <th scope="col" width="11%" class="darkValue" valign="bottom" nowrap style="text-align: left;padding:5 5 5 5"><b><bean-el:message key="label.activeDate"/></b></th>
                      <th scope="col" width="11%" class="darkValue" valign="bottom" nowrap style="text-align: left;padding:5 5 5 5"><b><bean-el:message key="label.inactivedate"/></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><img role="presentation" alt="add"  src="../images/spacer.gif" width="1" height="1" /></b></th>
                      <th scope="col" width="18%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><img role="presentation" alt="edit"  src="../images/spacer.gif" width="1" height="1" /></b></th>
                      <th scope="col" width="15%" class="darkValue" valign="bottom" wrap style="padding:5 5 5 5"><b><img role="presentation" alt="history"  src="../images/spacer.gif" width="1" height="1" /></b></th>
                    </tr>
                    </thead>     
                    
                   <c:if test="${not empty PlanNameSets}">
                   <tbody>
                    <c:forEach var="planNameSet" items="${PlanNameSets}" varStatus="status">
                    
                    <c:set var="setid" value="${planNameSet.entityKey.keyValue}"/>
                    <c:set var="counter" value="${status.count - 1}" />
                    <c:set var="rowColor" value="darkValue" />
                    <tr>
                      <td scope="row" width="35%" style="text-align: left;padding:5 5 5 5" class="moduleLabel">
                        <fw:link href="." onclick="expandOrCollapse(setList${counter}, setListImage${counter}, setListHiddenId${counter}); return false">
                          <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="setListImage${counter}" src="../images/redArrowRight.gif"/><c:out value="${planNameSet.name}"/>
                        </fw:link>
                        <input name="setListHiddenId<c:out value="${counter}"/>" id="setListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
                      </td> 
                      
                      <%-- 
                      <td colspan="2"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
                   --%>
                     <td width="11%" >&nbsp;</td>
                     <td width="11%" >&nbsp;</td>
                     
                      <td nowrap width="10%" style="text-align: center;font-size:10pt">
                        <c:if test="${addPermission}">
                            <fw:link action="/editHbps?methodName=ADD HBP">
                            <bean-el:message key="button.addHbp"/>
                          </fw:link>
                        </c:if>
                      </td>

                       <td nowrap width="18%" style="text-align: center;font-size:10pt">
                       <c:choose>
                       <c:when test="${editPermission}">
                             <fw:link action="/editPlanName?methodName=EDIT PLAN NAME">
                            <bean-el:message key="button.editPlanName"/>
                          </fw:link>
                        </c:when>
                        <c:otherwise>
                          <c:if test="${viewPermission}">
                             <fw:link action="/editPlanName?methodName=EDIT PLAN NAME">
                            <bean-el:message key="button.viewPlanName"/>
                          </fw:link>
                          </c:if>
                        </c:otherwise>
                        </c:choose>
                      </td>
                      
                      <td nowrap width="15%" style="text-align: center;font-size:10pt">
                        <c:if test="${viewPermission}">
  	                        <fw:link action="/viewHbpInformationHistory?methodName=DISPLAY&amp;history=viewHbpNamesFullHistory" paramId="entityId" paramName="planNameSet" paramProperty="entityKey.keyValue">
                            	<bean-el:message key="button.viewHistory"/>
                            </fw:link>
                         </c:if>
                      </td>            
                     </tr>
                     
                     <%-- insert expansion block here --%> 
                     
                     <%-- 
                     <tr>
                      <td colspan="7">
                        <div id="<c:out value="setList${counter}"/>" class="expandCollapseBody" style= "font-family: Verdana, Arial, Helvetica, sans-serif;
                            font-size: 11px;
                            font-weight: normal;
                            color: #000000;text-align: left;margin:5px 0px 0px 25px;">              
                          <c:forEach var="hbpDefinitions" items="${planNameSet.planDefinitions}" varStatus="status">
                           <c:out value="${hbpDefinitions.coverageCode} ${hbpDefinitions.planDescription.description}"/><br/><br/>
                          </c:forEach>
                        </div>
                      </td>
                    </tr>         
                    --%>
                    
                    
                  <tr>
                     <td colspan="6"> 
                     <div id="<c:out value="setList${counter}"/>" class="expandCollapseBody" style= "font-family: Verdana, Arial, Helvetica, sans-serif;
                            font-size: 12px;
                            font-weight: normal;
                            color: #000000;text-align: left;margin:5px 0px 0px 25px;"> 
          
                    <table summary="Table for Health Benefits Plan Definitions" width="100%" border="0" cellspacing="0" cellpadding="0" role="presentation">
           
                    <%-- I want following to be available in div block how to do that ????  --%>
                   <c:forEach var="hbpDefinition" items="${planNameSet.planDefinitions}" varStatus="hbpStatus">
                                 <c:set var="hbpid" value="${hbpDefinition.entityKey.keyValue}"/>
                                 <c:set var="hbpCoverageCode" value="${hbpDefinition.coverageCode}"/>
                                 <c:set var="hbpActiveDate" value="${hbpDefinition.effectiveDate}"/>
                                 <c:set var="hbpInactiveDate" value="${hbpDefinition.expirationDate}"/>
                                 <c:set var="hbpPlanCode" value="${hbpDefinition.planCode}"/>
                                 <c:set var="hbpDescription" value="${hbpDefinition.planDescription.description}" scope="request"/>
                                 <c:set var="hbpCounter" value="${hbpStatus.count - 1}" />
                                 <c:set var="hbpDescDisplay" value ="" scope="request" />
                                 <c:set var="rowColor" value="darkValue" />
                                 <%-- 
                                 <input name="hbpDesc" id="hbpDesc" type="hidden" value="<c:out value="${hbpDescription}"/>" />
                                 --%>

                  <tr>
                    
                  <td width="33%" class="<c:out value="${rowColor}"/> style="text-align: left;font-size:10pt">
                         <% 
                           String descStr = (String) request.getAttribute("hbpDescription");
                           String displayStr = "";
                           
                           if (null!=descStr && descStr.length() > 80 ) {
                               // System.out.println("desc from attribute="+ hbpDescTemp);
                               displayStr = descStr.substring(0,80) + "..." ;
                           }
                           else {
                               if (descStr == null || descStr.length()==0 )
                               {
                                  // System.out.println("desc from attribute is blank");
                                  // displayStr = "No Description Available";
                                   displayStr="";
                               }
                               else
                               {
                                   // System.out.println("desc from attribute length is less than 80");
                                   displayStr = descStr;   
                               }
                           }
                           // System.out.println("displaySstr = "+ descStr);
                           request.setAttribute("hbpDescDisplay", displayStr );
                           %>
                           
                           <c:out value="${hbpCoverageCode} ${hbpDescDisplay}"/> 
                   </td>
                    
                    <%-- 
                        <td nowrap width="10%" class="<c:out value="${rowColor}"/> style="text-align: left;padding:5 5 5 5">
                        <c:out value="${hbpActiveDate}"/>  
                       </td>
                       
                        <td nowrap width="10%" class="<c:out value="${rowColor}"/> style="text-align: left;padding:5 5 5 5">
                       <c:out value="${hbpInactiveDate}"/>    
                       </td>
                     --%>
                     
                      <td nowrap width="13%" class="<c:out value="${rowColor}"/> style="text-align: right;padding:5 5 5 5">
                        <esrcore:displayDate name="hbpDefinition" dateProperty="effectiveDate" displayTime="false" nullText=""/>
                      </td>
                      <td nowrap width="12%"  class="<c:out value="${rowColor}"/> style="text-align: right;padding:5 5 5 5">
                        <esrcore:displayDate name="hbpDefinition" dateProperty="expirationDate" displayTime="false" nullText=""/>
                      </td>
                       
                       <%-- 
                      <td colspan="1"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
                      --%>
                      <td width="7%" >&nbsp;</td>

                       <td nowrap width="20%" style="text-align: center;font-size:10pt">
                         <c:choose> 
                        <c:when test="${editPermission}">
                            <fw:link action="/editHbps?methodName=EDIT HBP">
                            <bean-el:message key="button.editHbp"/>
                          </fw:link>
                        </c:when>
                        <c:otherwise>
                          <c:if test="${viewPermission}">
                            <fw:link action="/editHbps?methodName=EDIT HBP">
                            <bean-el:message key="button.viewHbp"/>
                          </fw:link>
                          </c:if>
                        </c:otherwise>
                        </c:choose>
                      </td>   
                      
                      <td width="15%" >&nbsp;</td>
                      <%-- 
                      <td colspan="1"><img alt=""  src="../images/spacer.gif" width="1" height="1" /></td>
                      --%>
                 </tr>
        </c:forEach>
        </table>
     </div> 
     </td>
     </tr>
     
                     </c:forEach>
                    </tbody>
                    </c:if> 
                     
                 </table>
               </td>
             </tr>
    
            </table>
          </td>
        </tr> 
    
       <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
              <tr>
                <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="28" height="23"/></td>
                <td width="1%"><img alt=""  src="../images/redArrowRight.gif"></td>
                <td nowrap class="moduleLabel"><bean-el:message key="label.inactiveHbps"/></td>
                <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              </tr>
            </table>
          </td>
       </tr>     
 
 
      </table>
    </td>
  </tr>
  
  </html:form>
</table>
