<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Default to no permissions --%>
<c:set var="tabServiceUsers" value="false"/>
<c:set var="tabServieRequests" value="false"/>

<%-- Alt Text --%>
<c:set var="serviceUsersText" scope="page"><bean-el:message key="label.eeService.users"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="serviceRequestsText" scope="page"><bean-el:message key="label.eeService.requests"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="selectedTabText" scope="page"><bean-el:message key="label.selectedTab"/>,&nbsp;</c:set>

<%-- Re-enable permissions if the user has them --%>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADMINISTRATOR.getCode())">
  <c:set var="tabServiceUsers" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADMINISTRATOR.getCode())">
  <c:set var="tabServieRequests" value ="true"/>
</auth:authorize>

<%-- Set color and images for each tab based on it being selected or not. --%>
<c:choose>
<c:when test="${tabName == 'serviceUsers'}">
  <c:set var="serviceUsersImage" scope="page">on</c:set>
  <c:set var="serviceUsersText" scope="page" value="${selectedTabText}${serviceUsersText}"/>
</c:when>
<c:otherwise>
  <c:set var="serviceUsersImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'serviceRequests'}">
  <c:set var="serviceRequestsImage" scope="page">on</c:set>
  <c:set var="serviceRequestsText" scope="page" value="${selectedTabText}${serviceRequestsText}"/>
</c:when>
<c:otherwise>
  <c:set var="serviceRequestsImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>
<table cellSpacing="0" cellPadding="0" border="0">
  <tr valign="bottom">
    <c:if test="${tabServiceUsers == true}"><td><html-el:link styleClass="tabLink" forward="eeServiceUsers.list"><html-el:img alt="${serviceUsersText}" src="/esr/images/tabs_service accounts_${serviceUsersImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabServieRequests == true}"><td><html-el:link styleClass="tabLink" forward="eeServiceRequests.list"><html-el:img alt="${serviceRequestsText}" src="/esr/images/tabs_service requests_${serviceRequestsImage}.gif" border="0"/></html-el:link></td></c:if>
    <td width="100%" style="border-bottom: 1px solid #000000;"><img alt=""  src="../images/spacer.gif" height="1" width="100%"/></td>
  </tr>
</table>
