<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ page import='gov.va.med.esr.ui.common.util.JspUtils' %>
<%@ page import='gov.va.med.esr.common.model.lookup.VAFacility' %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="hecFacility"><%= VAFacility.CODE_HEC.getName() %></c:set>
<c:set var="editUserCode"><%=Capability.EDIT_USER_ACCOUNT.getName() %></c:set>
<c:set var="addUserCode"><%=Capability.ADD_NEW_USER.getName() %></c:set>
<c:set var="editLocalUserCode"><%=Capability.EDIT_LOCAL_USER.getName() %></c:set>
<c:set var="addLocalUserCode"><%=Capability.ADD_LOCAL_USER.getName() %></c:set>
<c:set var="readOnlyUser" value="true"/>
<c:set var="adminAllUsers" value="false"/>
<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/></c:set>

<auth:authorize access="hasAnyRole(${editUserCode},${addUserCode})">
	<c:set var="adminAllUsers" value="true"/>
</auth:authorize>
<c:choose>
	<c:when test="${empty userForm.userId}">
		<c:set var ="editUser" value="false"/>
		<auth:authorize access="hasAnyRole(${addUserCode},${addLocalUserCode},${editUserCode},${editLocalUserCode})">
			<c:set var="readOnlyUser" value="false"/>
		</auth:authorize>
	</c:when>
	<c:otherwise>
		<c:set var ="editUser" value="true"/>
		<auth:authorize access="hasAnyRole(${editUserCode},${editLocalUserCode})">
			<c:set var="readOnlyUser" value="false"/>
		</auth:authorize>
	</c:otherwise>
</c:choose>

<script>
function expandCollapseFG(elFacility, elFunctionalGroupTD, elFunctionalGroup)
{
	if (elFacility.value == "<c:out value="${hecFacility}"/>")
	{
		/* display functional group selection */
		elFunctionalGroupTD.style.display="block";
	}
	else
	{
		/* display functional group selection */
		elFunctionalGroupTD.style.display="none";
		elFunctionalGroup.value="";
	}
}
</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">



<html-el:form action="/editUserAccount" method="post">
 <%@ include file="/admin/csrfgentoken.jsp" %>
 <tr>
  <td>
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
    <tr>
     <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
       <tr>
		<td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
        <td nowrap class="moduleHeadline">
			<c:choose>
				<c:when test="${readOnlyUser == true}">
					View User Account
				</c:when>
				<c:when test="${editUser == true}">
					<bean-el:message key="label.editUser"/>
				</c:when>
				<c:otherwise>
					<bean-el:message key="label.addUser"/>
				</c:otherwise>
			</c:choose>
		</td>
		<td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
       </tr>
      </table>
     </td>
    </tr>

    <tr>
     <td>
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
        <tr>
            <td colspan="2">
              <%@ include file="/tiles/common/instructionalText.jsp" %>
            </td>
        </tr>
		<!-- read only fields -->
        <tr>
            <td width="45%" class="moduleLabel"><bean-el:message key="label.userid"/>:</td>
            <td width="55%" class="moduleValue">
				<esrcore:displayValue name="userForm" property="name" />
				<html-el:hidden name="userForm" property="name" />
				<html-el:hidden name="userForm" property="userId" />
			</td>
        </tr>
	    <!-- editable fields -->
        <tr>
            <c:set var="lastnameLabel"><bean-el:message key="label.lastname"/></c:set>
            <td width="45%" class="moduleLabel"><fw:label required="true" property="familyName" forId="txtFamilyName"><bean-el:message key="label.lastname"/>:</fw:label></td>
            <td width="55%" class="moduleValue"><html-el:text title="${requiredText}, ${lastnameLabel}" property="familyName" styleId="txtFamilyName" size="30" maxlength="40" readOnly="${readOnlyUser}" /></td>
        </tr>
        <tr>
            <c:set var="firstnameLabel"><bean-el:message key="label.firstname"/></c:set>
            <td width="45%" class="moduleLabel"><fw:label required="true" property="givenName" forId="txtGivenName"><bean-el:message key="label.firstname"/>:</fw:label></td>
            <td width="55%" class="moduleValue"><html-el:text title="${requiredText}, ${firstnameLabel}" property="givenName" styleId="txtGivenName" size="30" maxlength="30" readOnly="${readOnlyUser}"/></td>
        </tr>
        <tr>
            <c:set var="middlenameLabel"><bean-el:message key="label.middlename"/></c:set>
            <td width="45%" class="moduleLabel"><fw:label property="middleName" forId="txtMiddleName"><bean-el:message key="label.middlename"/>:</fw:label></td>
            <td width="55%" class="moduleValue"><html-el:text title="${middlenameLabel}" property="middleName" styleId="txtMiddleName" size="30" maxlength="30" readOnly="${readOnlyUser}"/></td>
        </tr>
        <tr>
            <c:set var="facilityLabel"><bean-el:message key="label.facility"/></c:set>
            <td width="45%" class="moduleLabel"><fw:label required="true" property="facility" forId="txtFacility"><bean-el:message key="label.facility"/>:</fw:label></td>
			<td class="moduleValue">
			<c:choose>
				<c:when test="${adminAllUsers == true}">
					<html-el:select title="${requiredText}, ${facilityLabel}" styleClass="moduleValue" property="facility"
					styleId="txtFacility" onchange="expandCollapseFG(facility,IdFunctionalGroup,functionalGroup); return false;">
					<html-el:option  value=""><bean-el:message key="label.select" /></html-el:option>
					<esrcore:options collection="gov.va.med.esr.common.model.lookup.VAFacility" property="code" labelProperty="facilityName"/>
				</html-el:select>
				</c:when>
				<c:otherwise>
					<esrcore:displayLookupValue name="userForm" property="facility" 
						lookupType="gov.va.med.esr.common.model.lookup.VAFacility" lookupProperty="facilityName"/>
					<html-el:hidden name="userForm" property="facility" />
				</c:otherwise>
			</c:choose>
			</td>
        </tr>
	<tr>
	    <c:set var="functionalGroupLabel"><bean-el:message key="label.functionalGroup"/></c:set>
            <td width="45%" class="moduleLabel"><fw:label property="functionalGroup" forId="functionalGroupId"><bean-el:message key="label.functionalGroup"/>:</fw:label></td>
			<c:set var="fgDisplayStatus" value="display:none"/>
			<c:if test="${userForm.facility == '742'}">
				<c:set var="fgDisplayStatus" value="display:block"/>
			</c:if>
			<td class="moduleValue" id="IdFunctionalGroup"  style="<c:out value="${fgDisplayStatus}"/>">
				<html-el:select title="${functionalGroupLabel}" styleClass="moduleEdit" property="functionalGroup" styleId="functionalGroupId" disabled="${readOnlyUser}">
					<html-el:option  value=""><bean-el:message key="label.select" /></html-el:option>
					<esrcore:options collection="gov.va.med.esr.common.model.lookup.FunctionalGroup" property="code" labelProperty="description"/>
                </html-el:select>
			</td>
		</tr>
        <tr>
            <c:set var="jobTitleLabel"><bean-el:message key="label.jobTitle"/></c:set>
            <td width="45%" class="moduleLabel"><fw:label property="jobTitle" forId="txtJobTitle"><bean-el:message key="label.jobTitle"/>:</fw:label></td>
            <td width="55%" class="moduleValue"><html-el:text title="${jobTitleLabel}" property="jobTitle" styleId="txtJobTitle" size="30" maxlength="80" readOnly="${readOnlyUser}"/></td>
        </tr>

		<c:if test="${editUser == true}">

        <tr>
            <td width="45%" class="moduleLabel"><bean-el:message key="label.agreementSignatureCode"/>:</td>
            <td width="55%" class="moduleValue">
				<esrcore:displayValue name="userForm" property="agreementSignatureCode" />
				<html-el:hidden name="userForm" property="agreementSignatureCode" />
			</td>
        </tr>
        <tr>
            <td width="45%" class="moduleLabel"><bean-el:message key="label.lastLoginDate"/>:</td>
            <td width="55%" class="moduleValue">
				<esrcore:displayValue name="userForm" property="lastLoginDate" />
				<html-el:hidden name="userForm" property="lastLoginDate" />
			</td>
        </tr>
        <tr>
           <c:set var="accountLockDateLabel"><bean-el:message key="label.accountLockDate"/></c:set>
            <th width="45%" class="moduleLabel"><fw:label property="accountLockDate"><bean-el:message key="label.accountLockDate"/>:</fw:label></th>
            <td width="55%" class="moduleValue"><html-el:text title="${accountLockDateLabel} ${mmddyyyyText}" property="accountLockDate" size="20" maxlength="10" readOnly="${readOnlyUser}" />&nbsp;<bean-el:message key="label.dateFormatmmddyyyy"/></td>
        </tr>
		</c:if>
		<!-- end of edit specific fields -->
		<%-- Button Row --%>
        <tr>
          <td colspan="2" height="50">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
              <tr>
				<c:choose>
					<c:when test="${readOnlyUser == true}">
				        <td width="48%"><img alt=""  src="../images/spacer.gif"/></td>
                        <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                        <td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
                        <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                        <td width="48%"><img alt=""  src="../images/spacer.gif"/></td>
					</c:when>
					<c:otherwise>
						<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<c:choose>
						<c:when test="${editUser == true}">
							<td>
							<html-el:submit property="methodName"
								style="width:50; vertical-align: top;" styleClass="buttonText">
							<bean-el:message key="button.update"/>
							</html-el:submit>
							</td>
						</c:when>
						<c:otherwise>
							<td>
								<html-el:submit property="methodName"
									style="width:50; vertical-align: top;" styleClass="buttonText">
								<bean-el:message key="button.add"/>
								</html-el:submit>
							</td>
							</c:otherwise>
						</c:choose>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
						<td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
						<td><html-el:submit property="methodName" style="width:50; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.cancel"/></html-el:submit></td>
						<td><img alt=""  src="../images/buttonEndRight.gif"/></td>
						<td width="45%"><img alt=""  src="../images/spacer.gif"/></td>
				    </c:otherwise>
				</c:choose>
              </tr>
            </table>
          </td>
        </tr>
      </table>
     </td>
    </tr>
   </table>
  </td>
 </tr>
</html-el:form>
</table>
