<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Default to no permissions --%>
<c:set var="tabActive" value="false"/>
<c:set var="tabManagement" value="false"/>

<%-- Alt Text --%>
<c:set var="managementText" scope="page"><bean-el:message key="label.management"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="activeText" scope="page"><bean-el:message key="label.active"/>&nbsp;<bean-el:message key="label.tab"/></c:set>
<c:set var="selectedTabText" scope="page"><bean-el:message key="label.selectedTab"/>,&nbsp;</c:set>

<%-- Re-enable permissions if the user has them --%>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADMINISTRATOR.getCode())">
  <c:set var="tabActive" value ="true"/>
</auth:authorize>
<auth:authorize access="hasAnyRole(T(gov.va.med.esr.common.model.lookup.Capability).ADMINISTRATOR.getCode())">
  <c:set var="tabManagement" value ="true"/>
</auth:authorize>

<%-- Set color and images for each tab based on it being selected or not. --%>
<c:choose>
<c:when test="${tabName == 'management'}">
  <c:set var="managementImage" scope="page">on</c:set>
  <c:set var="managementText" scope="page" value="${selectedTabText}${managementText}"/>
</c:when>
<c:otherwise>
  <c:set var="managementImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<c:choose>
<c:when test="${tabName == 'active'}">
  <c:set var="activeImage" scope="page">on</c:set>
  <c:set var="activeText" scope="page" value="${selectedTabText}${activeText}"/>
</c:when>
<c:otherwise>
  <c:set var="activeImage" scope="page">off</c:set>
</c:otherwise>
</c:choose>

<table cellSpacing="0" cellPadding="0" border="0">
  <tr valign="bottom">
    <c:if test="${tabManagement == true}"><td><html-el:link styleId="es-tabs-admin-batch-mgmt" styleClass="tabLink" forward="batchProcessManagement.display"><html-el:img alt="${managementText}" src="/esr/images/tabs_management_${managementImage}.gif" border="0"/></html-el:link></td></c:if>
    <c:if test="${tabActive == true}"><td><html-el:link styleId="es-tabs-admin-batch-active" styleClass="tabLink" forward="batchProcessActive.display"><html-el:img alt="${activeText}" src="/esr/images/tabs_active_${activeImage}.gif" border="0"/></html-el:link></td></c:if>
    <td width="100%" style="border-bottom: 1px solid #000000;"><img alt=""  src="../images/spacer.gif" height="1" width="100%"/></td>
  </tr>
</table>
