// $Id: util.js,v 1.4 2005/03/02 16:28:29 lmilner Exp $
/*
    function setFormFocus:
    
    Set the focus on the first visible element of the form.
*/
function setFormFocus(form)
{
    var elements = form.elements;
    var i = -1;
    while ( ++i < elements.length )
    {
        if ( elements[i].type != "hidden" )
        {
            elements[i].focus();
            return;
        }
    }
}

/*
    function trimTextArea
    
    Invoked when focus leaves a text area. 
    Trims text to maximum length.
    If a label is specified, alerts user if text was trimmed.
*/
function trimTextArea(textarea, length, label)
{
    if ( textarea.value.length > length - 1)   //Def #1319
    {
        textarea.value = textarea.value.substr(0, length);
        if ( label != null )
        {
//Def #1319     alert(label + " truncated to " + length + " characters");
        }
    }
}

/*
    function limitTextArea
    
    Invoked by onkeypress event.
    Prevents textarea from exceeding maximum length.
*/
function limitTextArea(event, textarea, length)
{
    if ( textarea.value.length <= length - 1)  //Def #1319
    {
        return true;
    }
    
    var c = event.which ? event.which : event.keyCode;
    
    // always allow navigation and character removal
    // ... Events like Ctl-X and Ctl-Y are mapped to keyCode 0
    if ( c == 0                     // Undefined
        || c == 8                   // backspace
        || c == 9                   // tab
        || ( 33 <= c && c <= 40 )   // page up/down, end/home, arrows
        || c == 46                  // delete
       )
    {
        return true;
    }
    
    // allow character replacement of selection
    var selectionLength = 
        document.selection ? 
            document.selection.createRange().text.length
            :
            textarea.selectionEnd - textarea.selectionStart;

    if ( textarea.value.length - selectionLength <= length - 1)  //Def #1319
    {
        return true;
    }
    trimTextArea(textarea, length, textarea.name);     //Def #1319
    return false;
}
