// $Id: sortTable.js,v 1.3 2004/09/02 19:25:20 lmilner Exp $
// Original source not attributed or licensed; made available as a code
// example.
//
// Original author: Porter Glendinning (http://glendinning.org/webbuilder/sortTable/)
// Enhanced by: Mark Raible (http://www.raibledesigns.com/page/rd/20030211#client_side_sorting_with_the)
// Adapted by: Jay Dunning, EDS
//    - allow indication of non-sortable columns
//    - place column sort spec in th instead of in init function args
//      - class name is "sortable:<type>", where <type> is 'string',
//        'numeric', etc
//    - different sort indicator graphic and logic
//    - other miscellaneous changes
//
// Requires the following elements in the document stylesheet:
// #SortedAscending
// {
// 	   background-image: url(images/asc.png);
// 	   background-repeat: no-repeat;
// 	   background-position: right;
// }
// #SortedDescending
// {
// 	   background-image: url(images/desc.png);
// 	   background-repeat: no-repeat;
// 	   background-position: right;
// }

function scriptLocation() {
    var scripts = document.getElementsByTagName("script");
    var i = scripts.length;
    while ( --i >= 0 ) {
        if ( scripts[i].src.indexOf("sortTable.js") >= 0 ) {
            return scripts[i].src;
        }
    }

    return null;
}

function scriptDir() {
    var location = scriptLocation();
    var p = location.lastIndexOf('/');
    if ( p >= 0 )
    {
        location = location.substring(0, p);
    }
    else
    {
        location = "";
    }

    return location;
}

var scriptDir = scriptDir();
// blank.png must be found in the following directory
// (may be overridden in global variable imageDir)
var defaultImageDir = scriptDir + 
    (scriptDir == "" ? "images" : "/../images");

// Initialize table sort.
// Call from body onload
// Parameters:
//  - id: id of sortable table
//  - sortColumn: offset of initial sort column
//    (sorts in ascending order)
//  - Sort or NoSort on initialize
//  - blankImage: url of blank image

function initSort(id, sortColumn, sortInd, blankImage) {
    var table = document.getElementById(id);
    var thead= table.getElementsByTagName("thead")[0];
    var cols = thead.getElementsByTagName("th");
    if ( sortColumn == null ) {
        for ( i = 0; i < cols.length; ++i ) {
            var className = cols[i].className;
            if ( className != null && className.substring(0, 9) == 'sortable:' ) {
                sortColumn = cols[i].cellIndex;
            }
        }
    }
    // loop through each header and attach an onclick event
    for (i=0; i < cols.length; i++) {
        var className = cols[i].className;
        if ( className != null && className.substring(0, 9) == 'sortable:' ) {
            cols[i].sortType = className.substring(9);
            cols[i].onclick = function() {sortTable(this,this.sortType)};
            cols[i].title = "Sort by " + cols[i].firstChild.nodeValue;
            var indicator = addSortImage(cols[i], blankImage);
            if ( sortColumn == cols[i].cellIndex )
            {
                if (sortInd == 'Sort')
                {            
                    setIndicator(cols[i], indicator, "asc");
                    sortTable(cols[i], cols[i].sortType, "asc");
                }
                else
                {
                    setIndicator(cols[i], indicator);
                }
            }
            else
            {
                setIndicator(cols[i], indicator);
            }
        }
    }
}

var sortedOn = -1;
var prevDirection = "";

function addSortImage(parentNode) {
    var indicator = document.createElement("img");
    if ( typeof(imageDir) == "undefined" )
    {
        imageDir = defaultImageDir;
    }
    indicator.setAttribute("src", imageDir + "/blank.png");
    indicator.setAttribute("width", "8");
    indicator.setAttribute("height", "7");
    indicator.setAttribute("alt", "");

    // allow users to tab to the th
    var anchor = document.createElement("a");
    anchor.href="javascript:";
    anchor.title = "Sort";
    anchor.appendChild(document.createTextNode(" "));
    parentNode.appendChild(anchor);

    parentNode.appendChild(indicator);
    return indicator;
}

function parentOf(element) {
    if ( element.parentNode ) {
        return element.parentNode;
    } else if ( element.parentElement ) {
        return element.parentElement;
    }
}

function sortTable(cell, type) {

    // figure out which column this is in the table, and the table
    table = parentOf(parentOf(parentOf(cell)));
    sortOn = cell.cellIndex;
    
    var tbody = table.getElementsByTagName('tbody')[0];
    var rows = tbody.getElementsByTagName('tr');

    var rowArray = new Array();
    for (var i=0, length=rows.length; i<length; i++) {
        rowArray[i] = rows[i].cloneNode(true);
    }

    var direction;
    if (sortOn == sortedOn) { 
        rowArray.reverse(); 
        direction = (prevDirection != "desc") ? "desc" : "asc";
    } else {
        direction = "asc";
        sortedOn = sortOn;

        if (type == "numeric") {
            rowArray.sort(rowCompareNumbers);
        } else if (type == "dollar") {
            rowArray.sort(rowCompareDollars);
        } else {
            rowArray.sort(rowCompare);
        }
    }
            
    var newTbody = document.createElement('tbody');
    for (var i=0, length=rowArray.length; i<length; i++) {
        newTbody.appendChild(rowArray[i]);
    }
    
    table.replaceChild(newTbody, tbody);
    
    var currentSortCell = document.getElementById("SortedAscending");
    if ( ! currentSortCell ) {
        currentSortCell = document.getElementById("SortedDescending");
    }
    if ( currentSortCell ) {
        currentSortCell.id="";
        var currentSortImage = currentSortCell.getElementsByTagName('img')[0];
        setIndicator(currentSortCell, currentSortImage, null);
    }

    var image = cell.getElementsByTagName('img')[0];
    
    setIndicator(cell, image, direction);
    prevDirection = direction;
}

function rowCompare(a, b) {
    var aVal = a.getElementsByTagName('td')[sortedOn].firstChild.nodeValue;
    var bVal = b.getElementsByTagName('td')[sortedOn].firstChild.nodeValue;
    return (aVal == bVal ? 0 : (aVal > bVal ? 1 : -1));
}

function rowCompareNumbers(a, b) {
    var aVal = parseInt(a.getElementsByTagName('td')[sortedOn].firstChild.nodeValue);
    var bVal = parseInt(b.getElementsByTagName('td')[sortedOn].firstChild.nodeValue);
    return (aVal - bVal);
}

function rowCompareDollars(a, b) {
    var aVal = parseFloat(a.getElementsByTagName('td')[sortedOn].firstChild.nodeValue.substr(1));
    var bVal = parseFloat(b.getElementsByTagName('td')[sortedOn].firstChild.nodeValue.substr(1));
    return (aVal - bVal);
}

function setIndicator(cell, indicator, direction) {
    if ( direction != null )
    {
        var name = (direction == "asc") ? "Ascending" : "Descending";
        indicator.setAttribute("alt", "Sorted in " + name + " order");
        indicator.className = "sorted" + name;
        cell.id = "Sorted" + name;
    }
    else
    {
        indicator.alt = "";
        indicator.className = "";
        cell.id = "";
    }
}
