// $Id: EditAssociation.js,v 1.1 2004/01/20 19:18:52 jdunning Exp $
/*
    File EditAssociation.js
    
    Scripts used by EditAssociation.html.
    
    These scripts enable and disable the add and remove buttons based
    on the control containing the current selection.
    
    Tested in Mozilla 1.3, IE 6.0, and Opera 7.20.
*/

// all of the following are private static members

var EditAssociation_isOpera = 
    navigator.userAgent.indexOf("Opera") >= 0;

/*
    Disable the element associated with an ID.
*/
function EditAssociation_disable(id)
{
    document.getElementById(id).disabled = true;
    if ( EditAssociation_isOpera )
    {
        document.getElementById(id).className = "submit-disabled";
    }
}

/*
    Enable the element associated with an ID.
*/
function EditAssociation_enable(id)
{
    document.getElementById(id).disabled = false;
    if ( EditAssociation_isOpera )
    {
        document.getElementById(id).className = "submit";
    }
}

/*
    Unselect any options in the select control associated with an ID.
*/
function EditAssociation_unselect(id)
{
    document.getElementById(id).selectedIndex = -1;
}

/*
    Respond to a click event within a select control.
    
    This event handler is installed at the document level so it won't
    interfere with typeahead selection.
    
*/
function EditAssociation_handleClick(e)
{
    var event  = e == null ? window.event : e;
    var element = event.target ? event.target : event.srcElement;
    if ( element.tagName == "SELECT" )
    {}
    else if ( element.tagName == "OPTION" )
    {
        element = element.parentNode;
    }
    else
    {
        return true;
    }

    if ( element.id == "selected" )
    {
        EditAssociation_selectSelected();
    }
    else
    if ( element.id == "unselected" )
    {
        EditAssociation_selectUnselected();
    }

    return true;
}

// The following are public static members

/*
    Respond to a selection in the Unselected selection list.
*/
function EditAssociation_selectUnselected()
{
    EditAssociation_enable('add');
    EditAssociation_disable('remove');
    EditAssociation_unselect('selected');
    return true;
}
    
/*
    Respond to a selection in the Selected selection list.
*/
function EditAssociation_selectSelected()
{
    EditAssociation_disable('add');
    EditAssociation_enable('remove');
    EditAssociation_unselect('unselected');
    return true;
}
    
/*
    Initialize controls on the EditAssociation page.
*/
function EditAssociation_initPage()
{
    EditAssociation_disable('add');
    EditAssociation_disable('remove');
    if ( document.getElementById('unselected').selectedIndex != -1 )
    {
        EditAssociation_selectUnselected();
    }
    if ( document.getElementById('selected').selectedIndex != -1 )
    {
        EditAssociation_selectSelected();
    }

    document.onclick = EditAssociation_handleClick;
}
