package gov.va.med.esr;

import gov.va.med.esr.jms.vadir.inboundRequest.Jaxb2Test;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;


public class Go2 {
	private static final Logger log = Logger.getLogger(Go.class);

	private JmsTemplate inboundJmsTemplate;

	public static void main(String[] args) {
		try {
			ApplicationContext appContext = new ClassPathXmlApplicationContext(
					"/applicationContext.xml");
			Go2 client = (Go2) appContext.getBean("go2");

			long requestId = Long.parseLong(String.valueOf((String)args[1]));
			String d =  String.valueOf((String)args[0]);
			long personId = Long.parseLong(d);
			log.debug("Sending VADIR JMS request " + requestId
					+ " with person " + personId + "...");
			client.simpleSend(requestId, personId, appContext);
			log.debug("Sent.");
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	public void simpleSend(long requestId, long personId, ApplicationContext appContext) throws Exception {
		final VadirServiceResponseWrapper responseWrapper = (new Jaxb2Test("MSDS")).createMinimalWrapper(personId, requestId, appContext);
		inboundJmsTemplate.send(new MessageCreator() {
			public Message createMessage(Session session) throws JMSException {
				ObjectMessage message = session.createObjectMessage(responseWrapper);
				message.setStringProperty("Message_Type", "MSDS");
				return message;
			}
		});
	}

	public void setInboundJmsTemplate(JmsTemplate outboundJmsTemplate) {
		this.inboundJmsTemplate = outboundJmsTemplate;
	}

}
