#--------------------------------------------
# Define environment-specific variables
#--------------------------------------------

eesvcAdminServerName = 'DNS   app43.aac.DNS   '
eesvcAdminServerPort = '7100'
eesvcUsername = ''
eesvcPassword = ''

eesvcMS1ServerName = 'DNS   app43.aac.DNS   '
eesvcMS2ServerName = 'DNS   app44.aac.DNS   '
eesvcClusterServerName = 'DNS   app43.aac.DNS   '
eesvcClusterPort = '7100'

esrMS2ServerName = 'DNS   app4.aac.DNS   '
esrMS4ServerName = 'DNS   app5.aac.DNS   '
esrClusterServerName = 'appclu2-pre.esr.healthevet.DNS   '
esrClusterPort = '7004'

#--------------------------------------------

eesvcT3MS1URL = 't3://' + eesvcMS1ServerName + ':' + eesvcClusterPort
eesvcT3MS2URL = 't3://' + eesvcMS2ServerName + ':' + eesvcClusterPort
eesvcT3ClusterURL = 't3://' + eesvcClusterServerName + ':' + eesvcClusterPort

esrT3MS2URL = 't3://' + esrMS2ServerName + ':' + esrClusterPort
esrT3MS4URL = 't3://' + esrMS4ServerName + ':' + esrClusterPort
esrT3ClusterURL = 't3://' + esrClusterServerName + ':' + esrClusterPort

eesvcT3AdminURL = 't3://' + eesvcAdminServerName + ':' + eesvcAdminServerPort

#-------------------------------------------- Connect

connect(eesvcUsername, eesvcPassword, eesvcT3AdminURL)
edit()
startEdit()

managedServers = ['MS1','MS2']
esrManagedServers = ['MS2','MS4']

#-------------------------------------------- Delete existing, if present

cd('/')

bridges = [
	'/Deployments/MSDS Request Bridge From MS2',
	'/Deployments/MSDS Request Bridge From MS4',
	'/Deployments/MSDS Response Bridge From MS1',
	'/Deployments/MSDS Response Bridge From MS2']

for bridge in bridges:
	testObj = getMBean()
	if (testObj != None):
		cmo.destroyMessagingBridge(testObj)

bridgeDestinations = [
	'/JMSBridgeDestinations/MSDS-RequestBridgeFromMS2Source',
	'/JMSBridgeDestinations/MSDS-RequestBridgeFromMS4Source',
	'/JMSBridgeDestinations/MSDS-RequestBridgeDestination',
	'/JMSBridgeDestinations/MSDS-ResponseBridgeFromMS1Source',
	'/JMSBridgeDestinations/MSDS-ResponseBridgeFromMS2Source',
	'/JMSBridgeDestinations/MSDS-ResponseBridgeDestination']

for bridgeDestination in bridgeDestinations:
	testObj = getMBean(bridgeDestination)
	if (testObj != None):
		cmo.destroyJMSBridgeDestination(testObj)

testObj = getMBean('/SystemResources/MSDS-Module')
if (testObj != None):
	cmo.destroyJMSSystemResource(testObj)

for managedServer in managedServers:
	testObj = getMBean('/Deployments/MSDSJmsServer@' + managedServer)
	if (testObj != None):
		cmo.destroyJMSServer(testObj)

for managedServer in managedServers:
	testObj = getMBean('/FileStores/MSDS File Store@' + managedServer)
	if (testObj != None):
		cmo.destroyFileStore(testObj)

#-------------------------------------------- MSDS File Stores
for managedServer in managedServers:
	cd('/')
	cmo.createFileStore('MSDS File Store@' + managedServer)
	cd('/FileStores/MSDS File Store@' + managedServer)
	set('Targets',jarray.array([ObjectName('com.bea:Name=EE' +
		managedServer + ',Type=Server')], ObjectName))

#-------------------------------------------- MSDS JMS Servers
for managedServer in managedServers:
	cd('/')
	cmo.createJMSServer('MSDSJmsServer@' + managedServer)
	cd('/Deployments/MSDSJmsServer@' + managedServer)
	cmo.setPersistentStore(getMBean('/FileStores/MSDS File Store@' + managedServer))
	set('Targets',jarray.array([ObjectName('com.bea:Name=EE' + managedServer +
		',Type=Server')], ObjectName))

#-------------------------------------------- MSDS Module

cd('/')
cmo.createJMSSystemResource('MSDS-Module')

cd('/SystemResources/MSDS-Module')
set('Targets',jarray.array([ObjectName('com.bea:Name=EECluster,Type=Cluster')], ObjectName))

#-------------------------------------------- MSDS Subdeployments

for managedServer in managedServers:
	cd('/SystemResources/MSDS-Module')
	cmo.createSubDeployment('MSDS Subdeployment@' + managedServer)
	cd('/SystemResources/MSDS-Module/SubDeployments/MSDS Subdeployment@' + managedServer)
	set('Targets',jarray.array([ObjectName('com.bea:Name=MSDSJmsServer@' +
		managedServer + ',Type=JMSServer')], ObjectName))

#-------------------------------------------- MSDS Connection Factories

for managedServer in managedServers:
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
	cmo.createConnectionFactory('MSDS Connection Factory@' + managedServer)
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/ConnectionFactories/MSDS Connection Factory@' +
		managedServer)
	cmo.setJNDIName('jms.MSDS-ConnectionFactory@' + managedServer)
	cmo.setDefaultTargetingEnabled(false)
	cmo.setSubDeploymentName('MSDS Subdeployment@' + managedServer)
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/ConnectionFactories/MSDS Connection Factory@' +
		managedServer + '/SecurityParams/MSDS Connection Factory@' + managedServer)
	cmo.setAttachJMSXUserId(false)

#-------------------------------------------- Queue Templates

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createTemplate('MSDS Inbound Queue Template')
cmo.createTemplate('MSDS Outbound Queue Template')

#-------------------------------------------- MSDS Inbound Queues

for managedServer in managedServers:
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
	cmo.createQueue('MSDS Inbound Queue@' + managedServer)
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue@' +
		managedServer)
	cmo.setTemplate(getMBean(
		'/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Templates/MSDS Inbound Queue Template'))
	cmo.setJNDIName('jms.MSDS-InboundQueue@' + managedServer)
	cmo.setSubDeploymentName('MSDS Subdeployment@' + managedServer)
	
#-------------------------------------------- MSDS Outbound Queues

for managedServer in managedServers:
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
	cmo.createQueue('MSDS Outbound Queue@' + managedServer)
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Outbound Queue@' + managedServer)
	cmo.setTemplate(getMBean(
		'/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Templates/MSDS Outbound Queue Template'))
	cmo.setJNDIName('jms.MSDS-OutboundQueue@' + managedServer)
	cmo.setSubDeploymentName('MSDS Subdeployment@' + managedServer)
	
#-------------------------------------------- MSDS Error Queues

for managedServer in managedServers:
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
	cmo.createQueue('MSDS Error Queue@' + managedServer)
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Error Queue@' + managedServer)
	cmo.setTemplate(getMBean(
		'/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Templates/MSDS Inbound Queue Template'))
	cmo.setJNDIName('jms.MSDS-ErrorQueue@' + managedServer)
	cmo.setSubDeploymentName('MSDS Subdeployment@' + managedServer)
	
#-------------------------------------------- MSDS Distributed Inbound Queue

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createDistributedQueue('MSDS Distributed Inbound Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/DistributedQueues/MSDS Distributed Inbound Queue')
cmo.setJNDIName('jms.MSDS-InboundQueue')
cmo.setLoadBalancingPolicy('Round-Robin')
for managedServer in managedServers:
	cmo.createDistributedQueueMember('MSDS Inbound Queue@' + managedServer)

#-------------------------------------------- Distributed Outbound Queue

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createDistributedQueue('MSDS Distributed Outbound Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/DistributedQueues/MSDS Distributed Outbound Queue')
cmo.setJNDIName('jms.MSDS-OutboundQueue')
cmo.setLoadBalancingPolicy('Round-Robin')
for managedServer in managedServers:
	cmo.createDistributedQueueMember('MSDS Outbound Queue@' + managedServer)

#-------------------------------------------- Redelivery for Inbound Queues

for managedServer in managedServers:
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue@' +
		managedServer + '/DeliveryFailureParams/MSDS Inbound Queue@' + managedServer)
	cmo.setRedeliveryLimit(48)
	cmo.setExpirationPolicy('Redirect')
	cmo.setErrorDestination(getMBean(
		'/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Error Queue@' + managedServer))
	cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue@' +
		managedServer + '/DeliveryParamsOverrides/MSDS Inbound Queue@' + managedServer)
	cmo.setRedeliveryDelay(3600000)

# =========================================================================== Bridge Destinations

#-------------------------------------------- Request Bridge From MS2 Source

cd('/')
cmo.createJMSBridgeDestination('MSDS-RequestBridgeFromMS2Source')

cd('/JMSBridgeDestinations/MSDS-RequestBridgeFromMS2Source')
cmo.setClasspath('')
cmo.setConnectionURL(esrT3MS2URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.OutboundMSDSQueue@MS2.JmsServer')

#-------------------------------------------- Request Bridge From MS4 Source

cd('/')
cmo.createJMSBridgeDestination('MSDS-RequestBridgeFromMS4Source')

cd('/JMSBridgeDestinations/MSDS-RequestBridgeFromMS4Source')
cmo.setClasspath('')
cmo.setConnectionURL(esrT3MS4URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.OutboundMSDSQueue@MS4.JmsServer')

#-------------------------------------------- Request Bridge Distributed Queue Destination

cd('/')
cmo.createJMSBridgeDestination('MSDS-RequestBridgeDestination')

cd('/JMSBridgeDestinations/MSDS-RequestBridgeDestination')
cmo.setClasspath('')
cmo.setConnectionURL(eesvcT3ClusterURL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.MSDS-InboundQueue')

#-------------------------------------------- Response Bridge From MS1 Source

cd('/')
cmo.createJMSBridgeDestination('MSDS-ResponseBridgeFromMS1Source')

cd('/JMSBridgeDestinations/MSDS-ResponseBridgeFromMS1Source')
cmo.setClasspath('')
cmo.setConnectionURL(eesvcT3MS1URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.MSDS-OutboundQueue@MS1')

#-------------------------------------------- Response Bridge From MS2 Source

cd('/')
cmo.createJMSBridgeDestination('MSDS-ResponseBridgeFromMS2Source')

cd('/JMSBridgeDestinations/MSDS-ResponseBridgeFromMS2Source')
cmo.setClasspath('')
cmo.setConnectionURL(eesvcT3MS2URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.MSDS-OutboundQueue@MS2')

#-------------------------------------------- Response Bridge Distributed Queue Destination

cd('/')
cmo.createJMSBridgeDestination('MSDS-ResponseBridgeDestination')

cd('/JMSBridgeDestinations/MSDS-ResponseBridgeDestination')
cmo.setClasspath('')
cmo.setConnectionURL(esrT3ClusterURL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.InboundMSDSQueue')

# =========================================================================== Bridges

#-------------------------------------------- Request Bridges

for managedServer in esrManagedServers:
	cd('/')
	cmo.createMessagingBridge('MSDS Request Bridge From ' + managedServer)
	cd('/Deployments/MSDS Request Bridge From ' + managedServer)
	set('Targets',jarray.array([ObjectName('com.bea:Name=EECluster,Type=Cluster')], ObjectName))
	cmo.setSourceDestination(getMBean('/JMSBridgeDestinations/MSDS-RequestBridgeFrom' + managedServer + 'Source'))
	cmo.setTargetDestination(getMBean('/JMSBridgeDestinations/MSDS-RequestBridgeDestination'))
	cmo.setStarted(true)
	cmo.setSelector('')
	cmo.setQualityOfService('Duplicate-okay')

#-------------------------------------------- Response Bridges

for managedServer in managedServers:
	cd('/')
	cmo.createMessagingBridge('MSDS Response Bridge From ' + managedServer)
	cd('/Deployments/MSDS Response Bridge From ' + managedServer)
	set('Targets',jarray.array([ObjectName('com.bea:Name=EECluster,Type=Cluster')], ObjectName))
	cmo.setSourceDestination(getMBean('/JMSBridgeDestinations/MSDS-ResponseBridgeFrom' + managedServer + 'Source'))
	cmo.setTargetDestination(getMBean('/JMSBridgeDestinations/MSDS-ResponseBridgeDestination'))
	cmo.setStarted(true)
	cmo.setSelector('')
	cmo.setQualityOfService('Duplicate-okay')

activate()
disconnect()