# Define environment-specific variables
#--------------------------------------------

eesvcAdminServerName = 'localhost'
eesvcAdminServerPort = '5001'
eesvcUsername = 'weblogic'
eesvcPassword = 'weblogic123'

eesvcMS1ServerName = 'localhost'
eesvcClusterServerName = 'localhost'
eesvcClusterPort = '7101'

#esrMS2ServerName = 'DNS   app14.aac.DNS   '
esrMS2ServerName = 'localhost'
esrClusterServerName = 'appclu2-dev.esr.healthevet.DNS   '
#esrClusterPort = '7312'
esrClusterPort = '7001'

#--------------------------------------------

eesvcT3MS1URL = 't3://' + eesvcMS1ServerName + ':' + eesvcClusterPort
eesvcT3ClusterURL = 't3://' + eesvcClusterServerName + ':' + eesvcClusterPort

esrT3MS2URL = 't3://' + esrMS2ServerName + ':' + esrClusterPort
esrT3ClusterURL = 't3://' + esrClusterServerName + ':' + esrClusterPort

eesvcT3AdminURL = 't3://' + eesvcAdminServerName + ':' + eesvcAdminServerPort

#-------------------------------------------- Connect

connect(eesvcUsername, eesvcPassword, eesvcT3AdminURL)
edit()
startEdit()

#-------------------------------------------- Delete existing, if present

cd('/')

testObj = getMBean('/Deployments/MSDS Request Bridge')
if (testObj != None):
	cmo.destroyMessagingBridge(testObj)

testObj = getMBean('/Deployments/MSDS Response Bridge')
if (testObj != None):
	cmo.destroyMessagingBridge(testObj)

testObj = getMBean('/JMSBridgeDestinations/MSDS-RequestBridgeDestination')
if (testObj != None):
	cmo.destroyJMSBridgeDestination(testObj)

testObj = getMBean('/JMSBridgeDestinations/MSDS-RequestBridgeSource')
if (testObj != None):
	cmo.destroyJMSBridgeDestination(testObj)

testObj = getMBean('/JMSBridgeDestinations/MSDS-ResponseBridgeDestination')
if (testObj != None):
	cmo.destroyJMSBridgeDestination(testObj)

testObj = getMBean('/JMSBridgeDestinations/MSDS-ResponseBridgeSource')
if (testObj != None):
	cmo.destroyJMSBridgeDestination(testObj)

testObj = getMBean('/SystemResources/MSDS-Module')
if (testObj != None):
	cmo.destroyJMSSystemResource(testObj)

testObj = getMBean('/Deployments/MSDSJmsServer')
if (testObj != None):
	cmo.destroyJMSServer(testObj)

testObj = getMBean('/FileStores/MSDS File Store')
if (testObj != None):
	cmo.destroyFileStore(testObj)

#-------------------------------------------- MSDS File Store

cmo.createFileStore('MSDS File Store')

cd('/FileStores/MSDS File Store')
set('Targets',jarray.array([ObjectName('com.bea:Name=EEMS1,Type=Server')], ObjectName))

#-------------------------------------------- MSDS JMS Server

cd('/')
cmo.createJMSServer('MSDSJmsServer')

cd('/Deployments/MSDSJmsServer')
cmo.setPersistentStore(getMBean('/FileStores/MSDS File Store'))
set('Targets',jarray.array([ObjectName('com.bea:Name=EEMS1,Type=Server')], ObjectName))

#-------------------------------------------- MSDS Module

cd('/')
cmo.createJMSSystemResource('MSDS-Module')

cd('/SystemResources/MSDS-Module')
set('Targets',jarray.array([ObjectName('com.bea:Name=EECluster,Type=Cluster')], ObjectName))

#-------------------------------------------- MSDS Subdeployment

cmo.createSubDeployment('MSDS Subdeployment')

#-------------------------------------------- MSDS Connection Factory

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createConnectionFactory('MSDS Connection Factory')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/ConnectionFactories/MSDS Connection Factory')
cmo.setJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDefaultTargetingEnabled(false)

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/ConnectionFactories/MSDS Connection Factory/SecurityParams/MSDS Connection Factory')
cmo.setAttachJMSXUserId(false)

cd('/SystemResources/MSDS-Module/SubDeployments/MSDS Subdeployment')
set('Targets',jarray.array([ObjectName('com.bea:Name=MSDSJmsServer,Type=JMSServer')], ObjectName))

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/ConnectionFactories/MSDS Connection Factory')
cmo.setSubDeploymentName('MSDS Subdeployment')

#-------------------------------------------- Queue Templates

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createTemplate('MSDS Inbound Queue Template')
cmo.createTemplate('MSDS Outbound Queue Template')

#-------------------------------------------- MSDS Inbound Queue

cmo.createQueue('MSDS Inbound Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue')
cmo.setTemplate(getMBean('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Templates/MSDS Inbound Queue Template'))
cmo.setJNDIName('jms.MSDS-InboundQueue@MS1')
cmo.setSubDeploymentName('MSDS Subdeployment')

cd('/SystemResources/MSDS-Module/SubDeployments/MSDS Subdeployment')
set('Targets',jarray.array([ObjectName('com.bea:Name=MSDSJmsServer,Type=JMSServer')], ObjectName))

#-------------------------------------------- MSDS Outbound Queue

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createQueue('MSDS Outbound Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Outbound Queue')
cmo.setTemplate(getMBean('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Templates/MSDS Outbound Queue Template'))
cmo.setJNDIName('jms.MSDS-OutboundQueue@MS1')
cmo.setSubDeploymentName('MSDS Subdeployment')

cd('/SystemResources/MSDS-Module/SubDeployments/MSDS Subdeployment')
set('Targets',jarray.array([ObjectName('com.bea:Name=MSDSJmsServer,Type=JMSServer')], ObjectName))

#-------------------------------------------- MSDS Error Queue

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createQueue('MSDS Error Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Error Queue')
cmo.setTemplate(getMBean('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Templates/MSDS Inbound Queue Template'))
cmo.setJNDIName('jms.MSDS-ErrorQueue@MS1')
cmo.setSubDeploymentName('MSDS Subdeployment')

cd('/SystemResources/MSDS-Module/SubDeployments/MSDS Subdeployment')
set('Targets',jarray.array([ObjectName('com.bea:Name=MSDSJmsServer,Type=JMSServer')], ObjectName))

#-------------------------------------------- MSDS Distributed Inbound Queue

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createDistributedQueue('MSDS Distributed Inbound Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/DistributedQueues/MSDS Distributed Inbound Queue')
cmo.setJNDIName('jms.MSDS-InboundQueue')
cmo.setLoadBalancingPolicy('Round-Robin')
cmo.createDistributedQueueMember('MSDS Inbound Queue')

#-------------------------------------------- Distributed Outbound Queue

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module')
cmo.createDistributedQueue('MSDS Distributed Outbound Queue')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/DistributedQueues/MSDS Distributed Outbound Queue')
cmo.setJNDIName('jms.MSDS-OutboundQueue')
cmo.setLoadBalancingPolicy('Round-Robin')
cmo.createDistributedQueueMember('MSDS Outbound Queue')

#-------------------------------------------- Inbound Queue Redelivery

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue/DeliveryFailureParams/MSDS Inbound Queue')
cmo.setRedeliveryLimit(48)
cmo.setExpirationPolicy('Redirect')

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue/DeliveryParamsOverrides/MSDS Inbound Queue')
cmo.setRedeliveryDelay(3600000)

cd('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Inbound Queue/DeliveryFailureParams/MSDS Inbound Queue')
cmo.setErrorDestination(getMBean('/JMSSystemResources/MSDS-Module/JMSResource/MSDS-Module/Queues/MSDS Error Queue'))

# =========================================================================== Bridge Destinations

#-------------------------------------------- Request Bridge Source

cd('/')
cmo.createJMSBridgeDestination('MSDS-RequestBridgeSource')

cd('/JMSBridgeDestinations/MSDS-RequestBridgeSource')
cmo.setClasspath('')
cmo.setConnectionURL(esrT3MS2URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
#cmo.setDestinationJNDIName('jms.OutboundMSDSQueue@MS2.JmsServer')
cmo.setDestinationJNDIName('jms.OutboundMSDSQueue')

#-------------------------------------------- Request Bridge Destination

cd('/')
cmo.createJMSBridgeDestination('MSDS-RequestBridgeDestination')

cd('/JMSBridgeDestinations/MSDS-RequestBridgeDestination')
cmo.setClasspath('')
cmo.setConnectionURL(eesvcT3ClusterURL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.MSDS-InboundQueue')

#-------------------------------------------- Response Bridge Source

cd('/')
cmo.createJMSBridgeDestination('MSDS-ResponseBridgeSource')

cd('/JMSBridgeDestinations/MSDS-ResponseBridgeSource')
cmo.setClasspath('')
cmo.setConnectionURL(eesvcT3MS1URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.MSDS-OutboundQueue@MS1')

#-------------------------------------------- Response Bridge Destination

cd('/')
cmo.createJMSBridgeDestination('MSDS-ResponseBridgeDestination')

cd('/JMSBridgeDestinations/MSDS-ResponseBridgeDestination')
cmo.setClasspath('')
cmo.setConnectionURL(esrT3MS2URL)
cmo.setAdapterJNDIName('eis.jms.WLSConnectionFactoryJNDINoTX')
cmo.setConnectionFactoryJNDIName('jms.MSDS-ConnectionFactory')
cmo.setDestinationJNDIName('jms.InboundMSDSQueue')

# =========================================================================== Bridges

#-------------------------------------------- Request Bridge

cd('/')
cmo.createMessagingBridge('MSDS Request Bridge')

cd('/Deployments/MSDS Request Bridge')
set('Targets',jarray.array([ObjectName('com.bea:Name=EECluster,Type=Cluster')], ObjectName))
cmo.setSourceDestination(getMBean('/JMSBridgeDestinations/MSDS-RequestBridgeSource'))
cmo.setTargetDestination(getMBean('/JMSBridgeDestinations/MSDS-RequestBridgeDestination'))
cmo.setStarted(true)
cmo.setSelector('')
cmo.setQualityOfService('Duplicate-okay')

#-------------------------------------------- Response Bridge

cd('/')
cmo.createMessagingBridge('MSDS Response Bridge')

cd('/Deployments/MSDS Response Bridge')
set('Targets',jarray.array([ObjectName('com.bea:Name=EECluster,Type=Cluster')], ObjectName))
cmo.setSourceDestination(getMBean('/JMSBridgeDestinations/MSDS-ResponseBridgeSource'))
cmo.setTargetDestination(getMBean('/JMSBridgeDestinations/MSDS-ResponseBridgeDestination'))
cmo.setStarted(true)
cmo.setSelector('')
cmo.setQualityOfService('Duplicate-okay')

activate()
disconnect()