package gov.va.med.esr.webservices.client.vadir;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.apache.log4j.Logger;

public class VadirThrottleController {
	
	private static final Logger logger = Logger.getLogger(VadirThrottleController.class);

	private static int currentthreadCount = 0;
	
	private static int throttleCount = -1;
	private static int throttleStartTime = 0;
	private static int throttleEndTime = 0;
	private static String isEMISProviderInUse = "NO";
	public static final String YES = "YES";
	public static final String NO = "NO";
	public static final String BOTH = "BOTH";
	
	private synchronized static void adjustThreadCount(int count) {
		currentthreadCount = getCurrentthreadCount() + count;
		logger.debug("Curr Thread Count :" + getCurrentthreadCount());
	} 
	
	
	static {
		try{
		   throttleStartTime = Integer.parseInt(System.getProperty("vadir.throttle.starttime"));
		   throttleEndTime = Integer.parseInt(System.getProperty("vadir.throttle.endtime"));
		   throttleCount = Integer.parseInt(System.getProperty("vadir.throttle.count"));
		   isEMISProviderInUse = System.getProperty("emis.provider.inuse");
		   if (isEMISProviderInUse == null) {
			   isEMISProviderInUse = NO;
		   }
		}catch(Exception e) {
			e.printStackTrace();
		}
	}

	public static String getIsEMISProviderInUse() {
		return isEMISProviderInUse;
	}

	public static void setIsEMISProviderInUse(String isEMISProviderInUse) {
		VadirThrottleController.isEMISProviderInUse = isEMISProviderInUse;
	}
	
	public static synchronized int getCurrentthreadCount() {
		return currentthreadCount;
	}

	public static void setCurrentthreadCount(int currentthreadCount) {
		VadirThrottleController.currentthreadCount = currentthreadCount;
	}

	public static int getThrottleCount() {
		return throttleCount;
	}

	public static void setThrottleCount(int throttleCount) {
		VadirThrottleController.throttleCount = throttleCount;
	}

	public static int getThrottleEndTime() {
		return throttleEndTime;
	}

	public static void setThrottleEndTime(int throttleEndTime) {
		VadirThrottleController.throttleEndTime = throttleEndTime;
	}

	public static int getThrottleStartTime() {
		return throttleStartTime;
	}

	public static void setThrottleStartTime(int throttleStartTime) {
		VadirThrottleController.throttleStartTime = throttleStartTime;
	}

	public static  void increaseCount(){
		
		//System.out.println("Increment count : enter");
		logger.debug("Increment count : enter");
		while ( getCurrentthreadCount() >= getThrottleCount()  && getThrottleCount() > 0 ) {
			try{
				logger.debug("Sleeping : current count:" + currentthreadCount + "--Allowed Count" + getThrottleCount() );
				Thread.sleep(100);
			}catch(Exception e ){
				//log exception here.
			}
		}
		//we are here because thread count in under control now.
		adjustThreadCount(1);
		logger.debug("Increment count : exit");
	}
	
	public static  void decreseCount() {
		logger.debug("decreseCount count : enter:" + getCurrentthreadCount() );
		adjustThreadCount(-1);
		logger.debug("decreseCount count : exit:" + getCurrentthreadCount());
	}
	
	
	public static boolean requireThrottle(){
		
	    SimpleDateFormat sdf = new SimpleDateFormat("HHmm");
		Calendar c1 = Calendar.getInstance(); // today
		int currTime =  Integer.parseInt(sdf.format(c1.getTime()));

		if ( throttleCount > 0 ) {
			if ( throttleStartTime > 0 && throttleEndTime > 0 ) {
				if ( throttleStartTime	< currTime && currTime < throttleEndTime) {
					return true;
				}
			}
		}
		return false;
	}

}
