package gov.va.med.esr.webservices.client.vadir;

import gov.va.schema.militaryhistory.MilitaryHistory;
import gov.va.schema.militaryhistory.ServicePeriod;
import gov.va.schema.militaryhistoryservice.SearchCriteria;

import javax.xml.datatype.DatatypeFactory;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class VadirClientThread extends Thread {
	
	private int threadNumber = 0;
	private ApplicationContext applicationContext = null;
	
	public ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	public int getThreadNumber() {
		return threadNumber;
	}

	public void setThreadNumber(int threadNumber) {
		this.threadNumber = threadNumber;
	}

	public void run() {
		VadirWSClientImpl client = (VadirWSClientImpl) applicationContext
				.getBean("vadirWSClient");


		try {
			DatatypeFactory dtf = DatatypeFactory.newInstance();
			SearchCriteria sc = new SearchCriteria();
			sc.setSSN("140663830");
			sc.setLastName("MCKANE");
			sc.setDateOfBirth(dtf.newXMLGregorianCalendar("1959-01-10"));
			sc.setICN("1008693885V036764");
			sc.setGender("M");
			MilitaryHistory mh = client.getMilitaryHistory(sc);

			if (mh == null) {
				System.out.println("No results found.");
			} else {
				System.out.println(ToStringBuilder.reflectionToString(mh,
						ToStringStyle.MULTI_LINE_STYLE));
				System.out.println("\nService Periods:");
				for (ServicePeriod period : mh.getVADIR().getServicePeriods()) {
					System.out.println(ToStringBuilder.reflectionToString(
							period, ToStringStyle.MULTI_LINE_STYLE));
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally{
			System.out.println("Thread Number Completed :" + threadNumber);
		}

	}
}
