package gov.va.med.esr.jms.vadir.outboundResponse;

import java.io.Serializable;

public class VadirServiceResponseWrapper implements Serializable {
	private static final long serialVersionUID = -7879037721558592273L;

	// ------------------------------------------ Fields

	/* The unique ID assigned to the request */
	private long requestId;
	/* Another unique ID representing a specific person assigned to this request */
	private long personId;

	/*
	 * The type of response; this should be an enum but we have to send this to
	 * jdk 1.4
	 */
	private int responseType;
	/* The response object, if the result was successful */
	private Serializable result;
	/* The error message, if the result was unsuccessful */
	private String errorMessage;

	// ------------------------------------------ Constructors

	public VadirServiceResponseWrapper() {
	}

	public VadirServiceResponseWrapper(long requestId, long personId,
			int responseType) {
		this.requestId = requestId;
		this.personId = personId;
		this.responseType = responseType;
	}

	public VadirServiceResponseWrapper(long requestId, long personId,
			int responseType, String errorMessage) {
		this(requestId, personId, responseType);
		this.errorMessage = errorMessage;
	}

	public VadirServiceResponseWrapper(long requestId, long personId,
			Serializable result) {
		this(requestId, personId, VadirServiceResponseType.NORMAL);
		this.result = result;
	}

	// ------------------------------------------ Common Methods

	public String toString() {
		return VadirServiceResponseWrapper.class.getName() + ": {requestId="
				+ requestId + ", responseType="
				+ VadirServiceResponseType.toName(responseType)
				+ ", errorMessage = " + errorMessage + "\nResponse: " + result
				+ "\n}";
	}

	// ------------------------------------------ Accessor Methods

	public int getResponseType() {
		return responseType;
	}

	public void setResponseType(int responseType) {
		this.responseType = responseType;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public Serializable getResult() {
		return result;
	}

	public void setResult(Serializable result) {
		this.result = result;
	}

	public long getRequestId() {
		return requestId;
	}

	public void setRequestId(long requestId) {
		this.requestId = requestId;
	}

	public long getPersonId() {
		return personId;
	}

	public void setPersonId(long personId) {
		this.personId = personId;
	}

}
