package gov.va.med.esr.jms.vadir.outboundResponse;

/**
 * Enumerated type that represents the various response types for a VADIR web
 * service request. This has to be source compatible with JDK 1.4 or I would
 * have made it an enum. Didn't bother to implement any more intelligent enum
 * type like Apache's, ints will work for now.
 * 
 * @author DNS   barryc
 */
public class VadirServiceResponseType {
	public static final int NORMAL = 0;
	public static final int REQUEST_ERROR = 1;

	public static boolean isError(int type) {
		return type > 0;
	}

	public static String toName(int type) {
		switch (type) {
		case NORMAL:
			return "Normal";
		case REQUEST_ERROR:
			return "Request Error";
		default:
			return "Unknown";
		}
	}
}
