package gov.va.med.esr.xml;

import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class JAXBUtility {
	private JAXBUtility(){
		
	}
	
	private static class JAXBHelperSingletonHolder{
		static JAXBUtility instance = new JAXBUtility();
	}
	
	public static JAXBUtility getInstance(){
		return JAXBHelperSingletonHolder.instance;
	}
	
	public <T> T unmarshalJaxbXmlElement( Class<T> klass, InputStream inputStream )
		    throws JAXBException {
		    String packageName = klass.getPackage().getName();
		    JAXBContext jc = JAXBContext.newInstance( packageName );
		    Unmarshaller u = jc.createUnmarshaller();
		    JAXBElement<T> doc = (JAXBElement<T>)u.unmarshal( inputStream );
		    return doc.getValue();
		}
	
	public <T> T unmarshalJaxbXmlRootElement( Class<T> klass, InputStream inputStream )
	    throws JAXBException {
	    String packageName = klass.getPackage().getName();
	    JAXBContext jc = JAXBContext.newInstance( packageName );
	    Unmarshaller u = jc.createUnmarshaller();
	    return (T) u.unmarshal( inputStream );
	}

}

