package gov.va.med.esr.webservices.client;

import gov.va.med.esr.mvc.model.RetrieveIVMCandidatesRequest;
import gov.va.med.esr.mvc.model.RetrieveIVMCandidatesResponse;
import gov.va.med.esr.xml.CastorUtility;

import java.util.Date;

import junit.framework.TestCase;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class IVMWebServiceIntegrationTest extends TestCase {
	
	public void testRetrieveIVMCandidatesRequest() throws Exception{
		CastorUtility.replaceMappingURL("spring/castor-mappings.xml");
		ApplicationContext appContext = new ClassPathXmlApplicationContext("classpath:client/application-context-test-client.xml");
		EESummaryClient client = (EESummaryClient) appContext.getBean("eeSummaryClient");
		RetrieveIVMCandidatesRequest requestPayload = new RetrieveIVMCandidatesRequest();
		requestPayload.setLastPolledDateTimeStamp(new Date());
		RetrieveIVMCandidatesResponse response = client.retrieveIVMCandidates(requestPayload);
		assertNotNull(response);
		assertNotNull(response.getEesVersion());
		assertNotNull(response.getInvocationDate());
		assertNotNull(response.getNumberOfCandidates());
	}
}
