package gov.va.med.esr.webservices.client;

import gov.va.med.esr.io.FileUtility;
import gov.va.med.esr.mvc.model.RetrieveIVMCandidatesRequest;
import gov.va.med.esr.mvc.model.RetrieveIVMCandidatesResponse;
import gov.va.med.esr.mvc.model.UpdateIVMRecordStatusRequest;
import gov.va.med.esr.mvc.model.UpdateIVMRecordStatusResponse;
import gov.va.med.esr.service.external.person.IVMCandidateInfo;
import gov.va.med.esr.xml.CastorUtility;
import gov.va.med.esr.xml.mapping.castor.DateHandler;
import gov.va.med.esr.xml.mapping.castor.DateTimeHandler;

import java.io.File;
import java.text.SimpleDateFormat;

import junit.framework.TestCase;

import org.springframework.core.io.ClassPathResource;

public class IVMOperationCastorTest extends TestCase{
	public void testUnMarshallingRetrieveIVMCandidatesReqeust() throws Exception{
		File xml = (new ClassPathResource("xml/RetrieveIVMCandidatesRequest.max.xml")).getFile();
		String expectedLastPolledDateTimeStamp = "2001-12-31T12:00:00";
		RetrieveIVMCandidatesRequest actualRequest = CastorUtility.unmarshall(xml, "spring/castor-mappings.xml", RetrieveIVMCandidatesRequest.class);
		assertNotNull(actualRequest);
		String actualLastPolledDateTimeStamp = (new SimpleDateFormat(DateTimeHandler.YYYY_MM_DDTHH_MM_SS_FORMAT)).format(actualRequest.getLastPolledDateTimeStamp());
		assertEquals(expectedLastPolledDateTimeStamp, actualLastPolledDateTimeStamp);
	}
	
	public void testUnMarshallingRetrieveIVMCandidatesResponse() throws Exception{
		String expectedInvocationDate = "2001-01-01", expectedEesVersion = "1.0";
		Integer expectedNumberOfCandidates = 2;
		String[][] expectedCandidateInfos = {{"VPID1", "IVM1"}, {"VPID2", "IVM2"}};
		File xml = (new ClassPathResource("xml/RetrieveIVMCandidatesResponse.max.xml")).getFile();
		
		RetrieveIVMCandidatesResponse actualResponse = CastorUtility.unmarshall(xml, "spring/castor-mappings.xml", RetrieveIVMCandidatesResponse.class);
		 
		assertNotNull(actualResponse);
		assertEquals(expectedEesVersion, actualResponse.getEesVersion());
		assertEquals(expectedInvocationDate, (new SimpleDateFormat(DateHandler.YYYY_MM_DD_FORMAT)).format(actualResponse.getInvocationDate()));
		assertEquals(expectedNumberOfCandidates, actualResponse.getNumberOfCandidates());
		assertNotNull(actualResponse.getCandidates());
		assertEquals(expectedNumberOfCandidates.intValue(), actualResponse.getCandidates().size());
		
		for(int i = 0; i< expectedCandidateInfos.length; i++){
			String[] expectedCandidateInfo = expectedCandidateInfos[i];
			assertEquals(expectedCandidateInfo[0], ((IVMCandidateInfo)actualResponse.getCandidates().get(i)).getVpid());
			assertEquals(expectedCandidateInfo[1], ((IVMCandidateInfo)actualResponse.getCandidates().get(i)).getTransactionId());
		}
	}
	
	public void testUnMarshallingUpdateIVMRecordStatusRecordRequest() throws Exception {
		File xml = (new ClassPathResource("xml/UpdateIVMRecordStatusRequest.max.xml")).getFile();
		String expectedTransactionId = "12345";
		String expectedErrorText = "Error processing request";		
		UpdateIVMRecordStatusRequest actualRequest = CastorUtility.unmarshall(xml, "spring/castor-mappings.xml", UpdateIVMRecordStatusRequest.class);
		assertNotNull(actualRequest);
		String actualTransactionId = actualRequest.getTransactionId();
		String actualErrorText = actualRequest.getErrorText();
		assertEquals(expectedTransactionId, actualTransactionId);
		assertEquals(expectedErrorText, actualErrorText);
	}
	
	public void testUnMarshallingUpdateIVMRecordStatusRecordResponse() throws Exception {
		File xml = (new ClassPathResource("xml/UpdateIVMRecordStatusResponse.max.xml")).getFile();
		String expectedAcknowledgement = "Pending", expectedStatus = "Complete", 
				expectedInvocationDate = "2001-01-01", expectedEesVersion = "1.0";
		UpdateIVMRecordStatusResponse actualResponse = CastorUtility.unmarshall(xml, "spring/castor-mappings.xml", UpdateIVMRecordStatusResponse.class);
		assertNotNull(actualResponse);
		assertEquals(expectedAcknowledgement, actualResponse.getAcknowledgement());
		assertEquals(expectedStatus, actualResponse.getStatus());
		assertEquals(expectedEesVersion, actualResponse.getEesVersion());
		assertEquals(expectedInvocationDate, (new SimpleDateFormat(DateHandler.YYYY_MM_DD_FORMAT)).format(actualResponse.getInvocationDate()));
	}
	
	public void testMarshallingRetrieveIVMCandidatesResponse() throws Exception{
		File xml = (new ClassPathResource("xml/RetrieveIVMCandidatesResponse.max.xml")).getFile();
		String expectedXml = FileUtility.mergeLines(FileUtility.readFile(xml));
		assertNotNull(expectedXml);
		RetrieveIVMCandidatesResponse actualResponse = CastorUtility.unmarshall(xml, "spring/castor-mappings.xml", RetrieveIVMCandidatesResponse.class);
		assertNotNull(actualResponse);
		String[][] namespaces = {{"p", "http://jaxws.webservices.esr.med.DNS   /schemas"}, {"xsi", "http://www.w3.org/2001/XMLSchema-instance"}};
		String schemaLocation = "http://jaxws.webservices.esr.med.DNS   /schemas ../../../main/resources/schemas/eeSummary.xsd";
		String actualXml = CastorUtility.marshall("spring/castor-mappings.xml", actualResponse, namespaces, schemaLocation);
		assertNotNull(actualXml);
		assertEquals(CastorUtility.removeFormatting(expectedXml), CastorUtility.removeFormatting(actualXml));
	}
	
	public void testMarshallingUpdateIVMRecordStatusRecordResponse() throws Exception {
		File xml = (new ClassPathResource("xml/UpdateIVMRecordStatusResponse.max.xml")).getFile();
		String expectedXml = FileUtility.mergeLines(FileUtility.readFile(xml));
		assertNotNull(expectedXml);
		UpdateIVMRecordStatusResponse actualResponse = CastorUtility.unmarshall(xml, "spring/castor-mappings.xml", UpdateIVMRecordStatusResponse.class);
		assertNotNull(actualResponse);
		String[][] namespaces = {{"p", "http://jaxws.webservices.esr.med.DNS   /schemas"}, {"xsi", "http://www.w3.org/2001/XMLSchema-instance"}};
		String schemaLocation = "http://jaxws.webservices.esr.med.DNS   /schemas ../../../main/resources/schemas/eeSummary.xsd";
		String actualXml = CastorUtility.marshall("spring/castor-mappings.xml", actualResponse, namespaces, schemaLocation);
		assertNotNull(actualXml);
		assertEquals(CastorUtility.removeFormatting(expectedXml), CastorUtility.removeFormatting(actualXml));
	}
}
