package gov.va.med.esr.webservices.client;

import java.io.File;

import gov.va.med.esr.io.FileUtility;
import gov.va.med.esr.mvc.model.EEModel;
import gov.va.med.esr.mvc.model.GetEESummaryRequest;
import gov.va.med.esr.xml.CastorUtility;
import gov.va.med.esr.xml.EESummaryTestHelper;
import junit.framework.TestCase;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EESummaryWebServiceIntegrationTest extends TestCase {
	/*
	 * To run integration test run ant command: ant integration-testing-package
	 * This command will inject a MockEEDelegate class into the EESummaryEndPoint class.
	 * The MockEEDelegate will not call make a remote call to the ESR application; but instead
	 * it will return a EEModel object that with a fully populated EESummary object.
	 */
	public void testGetEESummaryRequest() throws Exception{
		ApplicationContext appContext = new ClassPathXmlApplicationContext("classpath:client/application-context-test-client.xml");
		EESummaryClient client = (EESummaryClient) appContext.getBean("eeSummaryClient");
		GetEESummaryRequest requestPayload = new GetEESummaryRequest();
		requestPayload.setKey("0000001008591029V157554000000");
		requestPayload.setRequestName("IVMData");
		requestPayload.setIncomeYear(2011);
		EEModel actualResponse = client.getEESummaryRequest(requestPayload);
		assertChange_Request_11890(actualResponse);
		assertRegressionTest(actualResponse);
	}

	private void assertChange_Request_11890(EEModel actualResponse) {
		//TODO: NEED TO TEST eeSummary.financialsInfo.financialStatement.incomes.income.incomeReportDate **
		assertNotNull(actualResponse);
		assertNotNull(actualResponse.getSummary());
		EESummaryTestHelper.assertPerson(actualResponse.getSummary().getPersonInfo());
		EESummaryTestHelper.assertConsent(actualResponse.getSummary().getConsentInfo());

		assertNotNull(actualResponse.getSummary().getDemographics());
		assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo());
		assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getAddresses());
		assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getAddresses().getAddress());
		EESummaryTestHelper.assertAddress(actualResponse.getSummary().getDemographics().getContactInfo().getAddresses().getAddress()[0]);

		assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getPhones());
		assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getPhones().getPhone());
		EESummaryTestHelper.assertPhone(actualResponse.getSummary().getDemographics().getContactInfo().getPhones().getPhone()[0]);

		assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo());
		assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo());
		assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo().getMonetaryBenefits());
		assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo().getMonetaryBenefits().getMonetaryBenefit());
		EESummaryTestHelper.assertMonetartyBenefit(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo().getMonetaryBenefits().getMonetaryBenefit()[0]);

		assertNotNull(actualResponse.getSummary().getFinancialsInfo());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement());
		EESummaryTestHelper.assertFinancialStatement(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement());

		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getExpenses());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getExpenses().getExpense());
		EESummaryTestHelper.assertExpense(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getExpenses().getExpense()[0]);

		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getAssets());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getAssets().getAsset());
		EESummaryTestHelper.assertAsset(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getAssets().getAsset()[0]);

		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0]);
		assertEquals("p:prefix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getSpouse().getPrefix());
		assertEquals("p:suffix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getSpouse().getSuffix());
		assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getInpatientDays().intValue());
		assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getOutpatientDays().intValue());


		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0]);
		assertEquals("p:prefix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getDependentInfo().getPrefix());
		assertEquals("p:suffix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getDependentInfo().getSuffix());
		assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getInpatientDays().intValue());
		assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getOutpatientDays().intValue());

		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getNonPrimaryFinancialsInfo());
		assertNotNull(actualResponse.getSummary().getFinancialsInfo().getNonPrimaryFinancialsInfo().getNonPrimaryFinancialStatement());
		EESummaryTestHelper.assertNonPrimaryFinancialStatementInfo(actualResponse.getSummary().getFinancialsInfo().getNonPrimaryFinancialsInfo().getNonPrimaryFinancialStatement()[0]);
	}

	private void assertRegressionTest(EEModel actualResponse) {
		//TODO:  Need to implement.		
	}
}