package gov.va.med.esr.webservices.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.xml.soap.SOAPMessage;

import gov.va.med.esr.mvc.model.EEModel;
import gov.va.med.esr.mvc.model.GetEESummaryRequest;
import gov.va.med.esr.mvc.model.RetrieveIVMCandidatesRequest;
import gov.va.med.esr.mvc.model.RetrieveIVMCandidatesResponse;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.soap.security.xwss.XwsSecuritySecurementException;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSProcessorFactory;
import com.sun.xml.wss.XWSSecurityException;

public class EESummaryClient {
	public EESummaryClient(){
	}
	
	public RetrieveIVMCandidatesResponse retrieveIVMCandidates(RetrieveIVMCandidatesRequest requestPayload) throws Exception{
		return (RetrieveIVMCandidatesResponse) webServiceTemplate.marshalSendAndReceive(requestPayload, new SAAJHeaderMessageHandler("/client/wss-ivm-client-test-config.xml"));
	}
	
	public EEModel getEESummaryRequest(GetEESummaryRequest requestPayload) throws Exception {
		return (EEModel) webServiceTemplate.marshalSendAndReceive(requestPayload, new SAAJHeaderMessageHandler("/client/wss-ivm-client-test-config.xml"));
	}
	
	private WebServiceTemplate webServiceTemplate;

	public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
		this.webServiceTemplate = webServiceTemplate;
	}
	
	public class SAAJHeaderMessageHandler implements WebServiceMessageCallback {
		private XWSSProcessor cprocessor;
		private ProcessingContext context;
		public SAAJHeaderMessageHandler(String wssClientTestConfiguration) throws Exception{
			setCertificates();
			Resource xwssConfig = new ClassPathResource(wssClientTestConfiguration);
			if (!xwssConfig.exists()) {
				throw new FileNotFoundException();
			}
			XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();
			cprocessor = factory.createProcessorForSecurityConfiguration(xwssConfig.getInputStream(), null);
			context = new ProcessingContext();
			
		}
		public void doWithMessage(WebServiceMessage message) throws IOException {
			// We can cast safley to SaajSoapMessage   
			SaajSoapMessage saajSoapMessage = (SaajSoapMessage) message;
			SOAPMessage saajMessage = saajSoapMessage.getSaajMessage();
			try {
				context.setSOAPMessage(saajMessage);
				SOAPMessage securedMessage = cprocessor.secureOutboundMessage(context);
				saajSoapMessage.setSaajMessage(securedMessage);
			} catch (XWSSecurityException e) {
				throw new XwsSecuritySecurementException(e
						.getMessage());
			}
		}
		
		private void setCertificates() {
			System.out.println("trustStore :"+ System.getProperty("javax.net.ssl.trustStore"));
			if (System.getProperty("javax.net.ssl.trustStore") == null) {
				//String trustStoreName = System.getProperty("trustStoreName",
				//		"jssecacerts");
				//String trustStorePassword = System.getProperty(
				//		"javax.net.ssl.trustStorePassword", "changeit");

				//String trustStoreName = "jssecacerts";
				String trustStoreName = "D:/bea/projects/ESR.3.0.0/DNS   kavurt_HECMS_Websrv_1/vobs/HECMS_websrv/jssecacerts";

				trustStoreName = trustStoreName.replace('/', File.separatorChar);
				String trustStorePassword = "changeit";

				System.out.println("trustStoreName :" + trustStoreName);
				String detectedAbsolutePath = trustStoreName;

				//String detectedAbsolutePath = ClassLoader.getSystemResource(
				//		trustStoreName).getFile(); // assumes classpath can find it
				System.setProperty("javax.net.ssl.trustStore",detectedAbsolutePath);
				System.setProperty("javax.net.ssl.trustStorePassword",trustStorePassword);
				/**
				System.setProperty("javax.net.debug",
						"all");
				**/
			}
		}
	}	
}
