package gov.va.med.esr.webservices.client;

import gov.va.med.esr.io.FileUtility;
import gov.va.med.esr.mvc.model.EEModel;
import gov.va.med.esr.xml.CastorUtility;

import java.io.File;

import junit.framework.TestCase;

import org.springframework.core.io.ClassPathResource;

public class EESummaryCastorTest extends TestCase {
	public void test_Change_Request_11890() throws Exception{
		File expectedXmlRequestFile = (new ClassPathResource("xml/GetEESummaryResponse.xml")).getFile();
		String expectedXmlRequest = FileUtility.mergeLines(FileUtility.readFile(expectedXmlRequestFile));
		FileUtility.writeFile(new File("c:"+File.separator+"temp"+File.separator+"expectedEESummaryResponse.xml"), expectedXmlRequest);
		EEModel actualResponse = CastorUtility.unmarshall(expectedXmlRequestFile, "spring/castor-mappings.xml", EEModel.class);
		String[][] namespaces = {{"p", "http://jaxws.webservices.esr.med.DNS   /schemas"}, {"xsi", "http://www.w3.org/2001/XMLSchema-instance"}};
		String schemaLocation = "http://jaxws.webservices.esr.med.DNS   /schemas ../../../main/resources/schemas/eeSummary.xsd";
		String actualXmlResponse = CastorUtility.marshall("spring/castor-mappings.xml", actualResponse, namespaces, schemaLocation);
		FileUtility.writeFile(new File("c:"+File.separator+"temp"+File.separator+"actualEESummaryResponse.xml"),actualXmlResponse);
		assertNotNull(actualXmlResponse);
		assertEquals(CastorUtility.removeFormatting(expectedXmlRequest), CastorUtility.removeFormatting(actualXmlResponse));
	}
}


/*assertNotNull(actualResponse);
assertNotNull(actualResponse.getSummary());
EESummaryTestHelper.assertPerson(actualResponse.getSummary().getPersonInfo());
EESummaryTestHelper.assertConsent(actualResponse.getSummary().getConsentInfo());

assertNotNull(actualResponse.getSummary().getDemographics());
assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo());
assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getAddresses());
assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getAddresses().getAddress());
EESummaryTestHelper.assertAddress(actualResponse.getSummary().getDemographics().getContactInfo().getAddresses().getAddress()[0]);

assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getPhones());
assertNotNull(actualResponse.getSummary().getDemographics().getContactInfo().getPhones().getPhone());
EESummaryTestHelper.assertPhone(actualResponse.getSummary().getDemographics().getContactInfo().getPhones().getPhone()[0]);

assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo());
assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo());
assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo().getMonetaryBenefits());
assertNotNull(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo().getMonetaryBenefits().getMonetaryBenefit());
EESummaryTestHelper.assertMonetartyBenefit(actualResponse.getSummary().getEnrollmentDeterminationInfo().getMonetaryBenefitAwardInfo().getMonetaryBenefits().getMonetaryBenefit()[0]);

assertNotNull(actualResponse.getSummary().getFinancialsInfo());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement());
EESummaryTestHelper.assertFinancialStatement(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement());

assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getExpenses());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getExpenses().getExpense());
EESummaryTestHelper.assertExpense(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getExpenses().getExpense()[0]);

assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getAssets());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getAssets().getAsset());
EESummaryTestHelper.assertAsset(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getAssets().getAsset()[0]);

assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0]);
assertEquals("p:prefix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getSpouse().getPrefix());
assertEquals("p:suffix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getSpouse().getSuffix());
assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getInpatientDays().intValue());
assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getSpouseFinancialsList().getSpouseFinancials()[0].getOutpatientDays().intValue());


assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0]);
assertEquals("p:prefix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getDependentInfo().getPrefix());
assertEquals("p:suffix", actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getDependentInfo().getSuffix());
assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getInpatientDays().intValue());
assertEquals(0, actualResponse.getSummary().getFinancialsInfo().getFinancialStatement().getDependentFinancialsList().getDependentFinancials()[0].getOutpatientDays().intValue());

assertNotNull(actualResponse.getSummary().getFinancialsInfo().getNonPrimaryFinancialsInfo());
assertNotNull(actualResponse.getSummary().getFinancialsInfo().getNonPrimaryFinancialsInfo().getNonPrimaryFinancialStatementInfo());
EESummaryTestHelper.assertNonPrimaryFinancialStatementInfo(actualResponse.getSummary().getFinancialsInfo().getNonPrimaryFinancialsInfo().getNonPrimaryFinancialStatementInfo()[0]);*/