package gov.va.med.esr.delegates;

import gov.va.med.esr.mvc.model.DeliveryPreferenceModel;
import gov.va.med.esr.mvc.model.EDStatusModel;
import gov.va.med.esr.mvc.model.EEModel;
import gov.va.med.esr.mvc.model.EEModelHistory;
import gov.va.med.esr.mvc.model.PersonNotificationModel;
import gov.va.med.esr.mvc.model.UpdateDeliveryPreferenceModel;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.IVMLastPolledEntityFinder;
import gov.va.med.esr.service.external.person.IVMRecordStatusEntityFinder;
import gov.va.med.esr.service.external.person.IVMSummary;
import gov.va.med.esr.service.external.person.PIIData;
import gov.va.med.esr.service.external.person.PersonService;
import gov.va.med.esr.xml.EESummaryTestHelper;

import java.io.IOException;
import java.util.Map;

import javax.xml.bind.JAXBException;

public class MockEEDelegate extends EEDelegate{
	private Map<String, String> mockDataFileNames = null;
	
	public MockEEDelegate(Map<String, String> mockDataFileNames){
		super();
		this.mockDataFileNames = mockDataFileNames;
	}
	
	public EEModel getData(EntityFinder finder) {
		EEModel eeModel = new EEModel();
		try {
			eeModel.setSummary(EESummaryTestHelper.createMockEESummaryWithAbsoluteFilePath(mockDataFileNames.get("getData")));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace(); 
			throw new RuntimeException(e);
		} catch (JAXBException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}
		return eeModel;
	}
	
    public EEModelHistory getDataHistory(EntityFinder finder) {
        return invokeServiceHistory(finder);
    }
    public EDStatusModel getDataEDStatus(EntityFinder finder) {
        return invokeServiceEDStatus(finder);
    }
    public PersonNotificationModel getDataPersonNotificationStatus(EntityFinder finder) {
        return invokeServicePersonNotificationStatus(finder);
    }
    public DeliveryPreferenceModel getDataDeliveryPreference(EntityFinder finder) {
        return invokeServiceDeliveryPreference(finder);
    }
    public UpdateDeliveryPreferenceModel getDataUpdateDeliveryPreference(EntityFinder finder) {
        return invokeServiceUpdateDeliveryPreference(finder);
    }    
    private EEModelHistory invokeServiceHistory(EntityFinder finder) {
        try {
        	//NOTE: If you want to specific data for status, use "getDataHistory" key instead of "getData" key.
            EESummary soaResult = EESummaryTestHelper.createMockEESummaryWithAbsoluteFilePath(mockDataFileNames.get("getData")); //personService.getEESummaryHistory(finder);
            EEModelHistory wrapper = new EEModelHistory();
            wrapper.setServiceData(soaResult);          
            return wrapper;
        } catch(Exception e) {
            throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
        }
    }
    
    private EDStatusModel invokeServiceEDStatus(EntityFinder finder) {
		try {
			//NOTE: If you want to specific data for status, use "getDataEDStatus" key instead of "getData" key.
			EESummary soaResult = EESummaryTestHelper.createMockEESummaryWithAbsoluteFilePath(mockDataFileNames.get("getData")); //personService.getEDStatus(finder);
			EDStatusModel wrapper = new EDStatusModel();
			wrapper.setServiceData(soaResult);			
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}
   
    private PersonNotificationModel invokeServicePersonNotificationStatus(EntityFinder finder) {
		try {
			//NOTE: If you want to specific data for status, use "getDataPersonNotificationStatus" key instead of "getData" key.
			EESummary soaResult = EESummaryTestHelper.createMockEESummaryWithAbsoluteFilePath(mockDataFileNames.get("getData")); //personService.getPersonNotificationStatus(finder);
			PersonNotificationModel wrapper = new PersonNotificationModel();
			wrapper.setServiceData(soaResult);			
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}
    
    private DeliveryPreferenceModel invokeServiceDeliveryPreference(EntityFinder finder) {
		try {
			//NOTE: If you want to specific data for status, use "getDataDeliveryPreference" key instead of "getData" key.
			EESummary soaResult = EESummaryTestHelper.createMockEESummaryWithAbsoluteFilePath(mockDataFileNames.get("getData")); //personService.getDeliveryPreference(finder);
			DeliveryPreferenceModel wrapper = new DeliveryPreferenceModel();
			wrapper.setServiceData(soaResult);			
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}
    
    private UpdateDeliveryPreferenceModel invokeServiceUpdateDeliveryPreference(EntityFinder finder) {
        try {
        	//NOTE: If you want to specific data for status, use "getDataDeliveryPreference" key instead of "getData" key.
            EESummary soaResult = EESummaryTestHelper.createMockEESummaryWithAbsoluteFilePath(mockDataFileNames.get("getData")); //personService.updateDeliveryPreference(finder);
            UpdateDeliveryPreferenceModel wrapper = new UpdateDeliveryPreferenceModel();
            wrapper.setServiceData(soaResult);          
            return wrapper;
        } catch(Exception e) {
            throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
        }
    }

	public IVMSummary getIVMCandidatesData(IVMLastPolledEntityFinder finder) {
		return null; //personService.retrieveIVMCandidates(finder);
	}
	
	public IVMSummary getIVMRecordStatusData(IVMRecordStatusEntityFinder finder) {
		return null; //personService.updateIVMStatus(finder);
	}
}
