/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder.decorator;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class PreProcessValidator extends AbstractValidatorDecorator {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3724998136419436391L;
	private Builder preBuilder;

	public static Validator decorate(Validator validator, Builder preBuilder) {
		return new PreProcessValidator(validator, preBuilder);
	}

	private PreProcessValidator(Validator validator, Builder preBuilder) {
		super(validator);

		this.preBuilder = preBuilder;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.util.builder.AbstractValidator#processValidate(java.lang
	 * .Object)
	 */
	protected void processValidate(Object input) throws ValidatorException {
		try {
			super.getValidator().validate(this.preBuilder.build(input));
		} catch (BuilderException e) {
			throw new ValidatorException(e.getMessage(), e);
		}
	}
}