/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder.decorator;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.AbstractValidator;
import gov.va.med.fw.util.builder.Validator;

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public abstract class AbstractValidatorDecorator extends AbstractValidator {

	private static final long serialVersionUID = -1370346746640850300L;

	private Validator validator;

	protected AbstractValidatorDecorator(Validator validator) {
		super();

		if (validator == null) {
			throw new IllegalArgumentException("validator cannot be null");
		} else {
			this.validator = validator;
		}
	}

	protected final Validator getValidator() {
		return this.validator;
	}
}