/********************************************************************
 Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder;

/**
 * An exception that is thrown if a Builder Factory fails to create a builder
 * class that implements a Builder interface.
 * 
 * @author Vu Le
 * @version 1.0
 * @since 1.0
 */
public class BuilderException extends Exception {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6469802687768443427L;

	/**
	 * An instance of additional exception data
	 */
	private Object data = null;

	/**
	 * An empty exception
	 */
	public BuilderException() {
		super();
	}

	/**
	 * An exception with a specific message
	 * 
	 * @param msg
	 *            An exception message
	 */
	public BuilderException(String msg) {
		super(msg);
	}

	/**
	 * An exception with a specific parent exception
	 * 
	 * @param e
	 *            A parent exception in a chain
	 */
	public BuilderException(Throwable e) {
		super(e);
	}

	/**
	 * An exception with a specific parent exception and a message
	 * 
	 * @param e
	 *            A parent exception in a chain
	 * @param msg
	 *            An exception message
	 */
	public BuilderException(String msg, Throwable e) {
		super(msg, e);
	}

	/**
	 * @return Returns the data.
	 */
	public Object getData() {
		return data;
	}

	/**
	 * @param data
	 *            The data to set.
	 */
	public void setData(Object data) {
		this.data = data;
	}
}