/********************************************************************
 Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder;

// EDS Classes
import gov.va.med.fw.service.AbstractComponent;

/**
 * An abstract validator class that implements a Validator interface to
 * encapsulate how an object is validated. A derived class needs to provide a
 * concrete implementation for validating an object in a processValidate method.
 * 
 * @author Vu Le
 * @version 1.0
 * @since 1.0
 */
public abstract class AbstractValidator extends AbstractComponent implements Validator {

	private static final long serialVersionUID = -1370346746640850300L;

	/**
	 * An instance of a validator
	 */
	public AbstractValidator() {
		super();
	}

	/**
	 * Validates a raw object's data to ensure its contents are valid
	 * 
	 * @param input
	 *            A raw object to be validated
	 * @return Object a validated object
	 * @throws ValidatorException
	 *             Thrown if failed to validate an object
	 */
	public void validate(Object input) throws ValidatorException {

		if (input == null) {
			throw new ValidatorException("Input object must not be null");
		}
		// Delegate to this processValidate method to be consistent with
		// our design pattern in Builder, and a Formatter class
		processValidate(input);
	}

	/**
	 * Provides concrete implementation for validating an object.
	 * 
	 * @return Object a validated object
	 * @param input
	 *            A raw object to be validated
	 * @throws ValidatorException
	 *             Thrown if failed to validate an object
	 */
	protected abstract void processValidate(Object input) throws ValidatorException;
}
