/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.service.config;

import java.io.Serializable;

import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.core.Ordered;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Provides a default implementation for factory post processor that is called
 * after a factory is initialized.
 * 
 * Project: Framework</br> Created on: 1:30:11 PM </br>
 * 
 * @author DNS   LEV
 */
public abstract class AbstractBeanFactoryPostProcessor extends AbstractComponent implements
		BeanFactoryPostProcessor, Ordered, Serializable {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5449347499532912130L;

	/**
	 * Ensure it occurs late (eg, after property replacement).
	 */
	private int order = ConfigPriorityOrder.LOW;

	/**
	 * A default constructor
	 */
	protected AbstractBeanFactoryPostProcessor() {
		super();
	}

	/**
	 * @return Returns the order.
	 */
	public int getOrder() {
		return order;
	}

	/**
	 * @param order
	 *            The order to set.
	 */
	public void setOrder(int order) {
		this.order = order;
	}
}