/********************************************************************
Copyright  2004 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.service;

/**
 * A base exception for all service requests. This exception is thrown if a
 * request is not fulfilled successfully.
 *
 * @author  Vu Le
 * @version 1.0
 */
public class ServiceException extends Exception {
   
   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5419639461230634303L;

	/**
    * Creates new <code>ServiceException</code> without detail message.
    */
    public ServiceException() {
      super();
   }
   
    /**
     * Creates a new <code>ServiceException</code> with the specific cause
     */
     public ServiceException( Throwable cause ) {
       super(cause);
    }
     
	/**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message.
	 * 
	 * @param msg
	 *            the detail message.
    */
    public ServiceException(String msg) {
      super(msg);
   }
   
   /**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
    */
    public ServiceException(String msg, Throwable cause) {
      super( msg, cause );
   }
    
	public String getSimpleMessage() {
		return super.getMessage();
	}   
    
    @Override
    public String getMessage() {
    	String message = super.getMessage();
    	message = message != null ? message + getDetailedMessage() : getDetailedMessage();
    	return message;
    }
    
    public String getDetailedMessage() {
    	StackTraceElement[] trace = getStackTrace();
		StringBuilder stackTrace = new StringBuilder();
    	if(stackTrace != null) {
    		for(int i=0; i<trace.length; i++) {
    			if(trace[i] != null) {
    				stackTrace.append(trace[i].toString());
    				stackTrace.append("\n");
    			}
    		}
    	}
    	
    	Throwable ourCause = getCause(); 
    	while(ourCause != null) {
    		if (ourCause != null) {
    			stackTrace.append(ourCause.getMessage() + "\n");
    			ourCause = ourCause.getCause();
    		}
    	}
    	return stackTrace.toString();
    }
}
