/**
 * Created on 3:14:06 PM Jan 7, 2005
 * Project: UI
 * 
 * @author DNS   LEV
 */
package gov.va.med.fw.security;

// Framework classes
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.HashSummary;
import gov.va.med.fw.util.HashUtils;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * A value object containing data representing user information
 */
public class UserCredentials extends AbstractEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4829641509142056866L;

	/**
	 * A user's id that is used for logon purposes (ie, authenticated against)
	 */
	private String userID = null;

	/**
	 * A logical name for this user. It is not used for logon purposes, but more
	 * for optional logical identification. For example, a user could
	 * authenticate with "JSMITH" (userID) but system requirements dictate that
	 * they are audited in the system as "HQ USER (userName). This also allows
	 * for post-authentication of setting a logical name.
	 */
	private String logicalID = null;

	/**
	 * A user's password
	 */
	private String password = null;
	/**
	 * An optional security code for validation
	 */
	private String securityCode = null;

	private boolean anonymous = false;
	private boolean verified = false;

	/**
	 * An empty value object containing user information
	 */
	public UserCredentials() {
		super();
	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password
	 *            The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return Returns the userName.
	 */
	public String getUserID() {
		return userID;
	}

	/**
	 * @param userName
	 *            The userName to set.
	 */
	public void setUserID(String userName) {
		this.userID = userName;
	}

	public String getSecurityCode() {
		return securityCode;
	}

	public void setSecurityCode(String securityCode) {
		this.securityCode = securityCode;
	}

	/**
	 * @return Returns the logicalID.
	 */
	public String getLogicalID() {
		return logicalID;
	}

	/**
	 * @param logicalID
	 *            The logicalID to set.
	 */
	public void setLogicalID(String logicalID) {
		this.logicalID = logicalID;
	}

	/**
	 * @return Returns the anonymous.
	 */
	public boolean isAnonymous() {
		return anonymous;
	}

	/**
	 * @param anonymous
	 *            The anonymous to set.
	 */
	public void setAnonymous(boolean anonymous) {
		this.anonymous = anonymous;
	}

	/**
	 * Builds a string representation of a user information
	 * 
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("userID", getUserID());
		builder.append("logicalID", getLogicalID());
		//builder.append("password", getPassword());
		builder.append("securityCode", getSecurityCode());
		builder.append("anonymous", isAnonymous());
	}

	/**
	 * @return Returns the verified.
	 */
	public boolean isVerified() {
		return verified;
	}

	/**
	 * @param verified
	 *            The verified to set.
	 */
	void setVerified(boolean verified) {
		this.verified = verified;
	}
	
	public String hashUserCredentials() throws Exception {
		HashSummary hashSummary = HashUtils.hash(password, getUserID().toUpperCase(), HashUtils.DEFAULT_ALGORITHM);
		this.password = hashSummary.getHashSummary();
		return password;
	}
}
