/********************************************************************
 * Copyright  2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Generic Application class to define the application name
 * 
 * CISS ciss_framework Jun 26, 2008
 * 
 * @author DNS   katikm
 */
public class Application extends AbstractKeyedEntity {

	private static final long serialVersionUID = 8889116142186167200L;

	public static final String CISS = "CISS";
	public static final String OHRS = "OHRS";

	private String applicationName;
	private String applicationDescription;

	/**
	 * @return the applicationName
	 */
	public String getApplicationName() {
		return applicationName;
	}

	/**
	 * @param applicationName
	 *            the applicationName to set
	 */
	public void setApplicationName(String applicationName) {
		this.applicationName = applicationName;
	}

	/**
	 * @return the applicationDescription
	 */
	public String getApplicationDescription() {
		return applicationDescription;
	}

	/**
	 * @param applicationDescription
	 *            the applicationDescription to set
	 */
	public void setApplicationDescription(String applicationDescription) {
		this.applicationDescription = applicationDescription;
	}

}
