/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import javax.security.auth.login.LoginException;

/**
 * This exception is thrown when the user account is locked.
 * 
 * @author DNS   MANSOG
 * @date Apr 22, 2005 12:29:36 PM
 */
public class AccountLockedException extends LoginException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8092705721146332214L;

	/**
	 * A default constructor for an exception without a message and a cause
	 */
	public AccountLockedException() {
		super();
	}

	/**
	 * A constructor for an exception with the specific message
	 * 
	 * @param msg
	 *            An exception message
	 */
	public AccountLockedException(String msg) {
		super(msg);
	}

	/**
	 * A constructor for the specific exception message and a cause
	 * 
	 * @param msg
	 *            An exception message
	 * @param cause
	 *            A cause of this exception
	 */
	public AccountLockedException(String msg, Throwable cause) {
		this(msg);
		initCause(cause);
	}
}
