/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import javax.security.auth.login.LoginException;

/**
 * This exception is thrown when a user account is disable.
 * 
 * @author DNS   MANSOG
 * @date Apr 22, 2005 12:29:36 PM
 */
public class AccountDisabledException extends LoginException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2135551579374726220L;

	/**
	 * A default constructor for an exception without a message and a cause
	 */
	public AccountDisabledException() {
		super();
	}

	/**
	 * A constructor for an exception with the specific message
	 * 
	 * @param msg
	 *            An exception message
	 */
	public AccountDisabledException(String msg) {
		super(msg);
	}

	/**
	 * A constructor for the specific exception message and a cause
	 * 
	 * @param msg
	 *            An exception message
	 * @param cause
	 *            A cause of this exception
	 */
	public AccountDisabledException(String msg, Throwable cause) {
		this(msg);
		initCause(cause);
	}
}