/**
 * 
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.persistent.DAOException;

import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.hibernate.HibernateException;

/**
 * @author DNS   katikm
 *
 */
public class NamedQueryUpdateAction extends AbstractDAOAction {

	private String queryName;
	
	public NamedQueryUpdateAction(String queryName, Map<String, Object> contextData){
		super(contextData);
		this.queryName = queryName;
		
	}
	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.hibernate.AbstractDAOAction#execute(javax.persistence.EntityManager)
	 */
	@Override
	protected Object execute(EntityManager entityManager) throws DAOException {
		try {
        	//Create temp table and identify the new and modified records
        	Query query = entityManager.createNamedQuery(queryName); 
        	//set parameters if any are defined
        	AbstractDAOImpl.setQueryParameters(query, getContextData());
        	//return the update count
        	return new Integer(query.executeUpdate()); 
		}catch( Exception e ) {
            throw new HibernateException( e.getMessage(), e );
        }
 	}
}
