/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.persistent.DAOException;

import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;

import org.hibernate.CallbackException;
import org.springframework.orm.jpa.JpaCallback;

/**
 * Implements HibernateCallback interface to provide more flexibilities to a
 * caller to perform any persistent operation using Hibernate session. This
 * abstract class is intended to allow derived classes to be configured as a
 * spring managed bean so that its dependencies and resources can be injected
 * through an application context file in XML format.
 * 
 * Project: Framework
 * 
 * @author DNS   LEV
 * @version 1.0
 */
public abstract class AbstractDAOAction implements JpaCallback {
	private Map<String, Object> contextData;

	/**
	 * A default constructor
	 */
	protected AbstractDAOAction() {
		super();
	}

	protected AbstractDAOAction(Map<String, Object> contextData) {
		super();
		this.contextData = contextData;
	}

	public Object doInJpa(EntityManager entityManager) throws PersistenceException {
		try {
			return execute(entityManager);
		} catch (DAOException e) {
			throw new CallbackException(e);
		}
	}

	protected abstract Object execute(EntityManager entityManager) throws DAOException;

	/**
	 * @return Returns the contextData.
	 */
	public Map<String, Object> getContextData() {
		return contextData;
	}

	/**
	 * @param contextData
	 *            The contextData to set.
	 */
	public void setContextData(Map<String, Object> contextData) {
		this.contextData = contextData;
	}
}
