/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.persistent;

// Java classes
import java.io.Serializable;

import gov.va.med.fw.model.EntityKey;

/**
 * A generic interface to provide standard operations for persisting an object
 * 
 * @author Vu Le
 * @version 1.0
 */
public interface DAO extends Serializable {

	/**
	 * Generic method to return a persistent instance of a given entity class
	 * with the given identifier, or null if not found
	 * 
	 * @param obj
	 *            An entity to query
	 * @param id
	 *            An entity's id
	 * @return a populated object (or null if id doesn't exist)
	 * @throws DAOException
	 *             Thrown if failed to query an object
	 */
	public <T> T getByKey(EntityKey<T> key) throws DAOException;

	/**
	 * Generic method to insert an object. Returns the identifier after
	 * inserting an object.
	 * 
	 * @param obj
	 * @return EntityKey An entity key
	 * @throws DAOException
	 *             if failed to insert an object.
	 */
	public <T> EntityKey<T> insertObject(T obj) throws DAOException;

	/**
	 * Generic method to save an object - handles both update and insert.
	 * 
	 * @param obj
	 *            the object to save
	 * @throws DAOException
	 *             Thrown if failed to save an object
	 */
	public Object saveObject(Object obj) throws DAOException;

	/**
	 * Generic method to delete an object
	 * 
	 * @param obj
	 *            the object to delete
	 * @throws DAOException
	 *             Thrown if failed to remove an object
	 */
	public void removeObject(EntityKey<?> id) throws DAOException;

	/**
	 * Generic method to execute a simple named query
	 * 
	 * @param query
	 *            Query to execute
	 * @throws DAOException
	 *             Thrown if failed to remove an object
	 */
	// public List find(String query) throws DAOException;
}
