/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.persistent;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.service.AbstractComponent;

/**
 * General after-advice that can be applied to any service call that returns an
 * AbstractKeyedEntity.
 * 
 * Created Mar 3, 2006 9:56:07 AM
 * 
 * @author DNS   BOHMEG
 */
public abstract class AbstractKeyedEntitySubmittedAdvice extends AbstractComponent implements
		MethodInterceptor {
	private String submitter;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept
	 * .MethodInvocation)
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Object result = invocation.proceed();
		if (result instanceof AbstractKeyedEntity)
			processEntitySubmitted((AbstractKeyedEntity) result, invocation.getArguments());
		else {
			if (logger.isWarnEnabled() && result != null)
				logger.warn("Returned value is not an instance of AbstractKeyedEntity (type: "
						+ result.getClass().getName() + "), not applying any after advice");
		}
		return result;
	}

	protected abstract void processEntitySubmitted(AbstractKeyedEntity entity,
			Object[] methodArguments) throws Exception;

	/**
	 * @return Returns the submitter.
	 */
	public String getSubmitter() {
		return submitter;
	}

	/**
	 * @param submitter
	 *            The submitter to set.
	 */
	public void setSubmitter(String submitter) {
		this.submitter = submitter;
	}

	public void afterPropertiesSet() {
		Validate.notNull(submitter, "submitter can not be null");
	}
}
