/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.lookup;

/**
 * Well known applications of the Model Properties Service.
 * 
 * Created Sep 6, 2006 2:24:12 PM
 * 
 * @author DNS   BOHMEG
 */
public class ModelPropertiesApplicationType extends AbstractSimpleLookup {

	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 2691206071436241022L;

	/**
	 * IDENTITY is used for pure equality/hashCode implementations and typically
	 * use ALL object properties including infrastructure properties (with
	 * expection to circular references)
	 */
	public static final ModelPropertiesApplicationType IDENTITY = new ModelPropertiesApplicationType(
			"identity");

	/**
	 * COPY is used to identify properties that should be copied onto a like
	 * target object
	 */
	public static final ModelPropertiesApplicationType COPY = new ModelPropertiesApplicationType(
			"copy");

	/**
	 * MATCH_DOMAIN_VALUES is used to determine if two like objects represent
	 * the same domain object with respect to all the configured domain
	 * properties.
	 * 
	 * <p>
	 * For example, when matching an Address object, this will include the type
	 * (eg, Permanent, Temporary), address, city, state, and zip. Assume these
	 * are all the domain properties.
	 * 
	 * <p>
	 * This differs from IDENTITY in that infrastructure properties are NOT
	 * accounted for (eg, identifier, lastUpdatedBy, createdDate, etc).
	 */
	public static final ModelPropertiesApplicationType MATCH_DOMAIN_VALUES = new ModelPropertiesApplicationType(
			"matchDomainValues");

	/**
	 * MATCH_DOMAIN_CONCEPT is used to determine if two like objects represent
	 * the same domain concept with respect to all the configured business
	 * properties. Typically this is implemented as a partial subset of
	 * configured properties for MATCH_DOMAIN_VALUES and allows for quick
	 * picking of a domain concept match in a collection of other like objects.
	 * 
	 * <p>
	 * For example, when matching an Address object, this will only include the
	 * type (eg, Permanent, Temporary).
	 * 
	 * <p>
	 * This differs from MATCH_DOMAIN_VALUES in that not all domain properties
	 * should be inspected.
	 */
	public static final ModelPropertiesApplicationType MATCH_DOMAIN_CONCEPT = new ModelPropertiesApplicationType(
			"matchDomainConcept");

	private ModelPropertiesApplicationType(String code) {
		super(code);
	}
}
