// Package 
package gov.va.med.fw.model.lookup;

// Java Classes
import java.util.Comparator;

/**
 * A NamedLookup Comparator that compares on the "name" field.
 * 
 * @author Andrew Pach
 * @version 4.0
 */
public class LookupNameComparator implements Comparator<NamedLookup> {
	/**
	 * Default constructor.
	 */
	public LookupNameComparator() {
	}

	public int compare(NamedLookup lookup1, NamedLookup lookup2) {
		String name1 = (lookup1 != null) ? (lookup1.getName()) : null;
		String name2 = (lookup2 != null) ? (lookup2.getName()) : null;
		return (name1 != null && name2 != null) ? name1.compareTo(name2) : 0;
	}
}
