// Package 
package gov.va.med.fw.model.lookup;

// Java Classes
import java.util.Comparator;

/**
 * A Lookup Comparator that compares on the "description" field.
 * 
 * @author Andrew Pach
 * @version 4.0
 */
public class LookupDescriptionComparator implements Comparator<Lookup> {
	/**
	 * Default constructor.
	 */
	public LookupDescriptionComparator() {
	}

	public int compare(Lookup lookup1, Lookup lookup2) {
		String description1 = (lookup1 != null) ? (lookup1.getDescription()) : null;
		String description2 = (lookup2 != null) ? (lookup2.getDescription()) : null;
		return (description1 != null && description2 != null) ? description1
				.compareTo(description2) : 0;
	}
}
