/********************************************************************
 * Copyright  2009 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model;

import gov.va.med.fw.util.StringUtils;

import java.io.Serializable;
import java.security.MessageDigest;


/**
 * TODO - Add doco here
 *
 * Original Author - DNS   BOHMEG
 * Creation Date - Nov 6, 2009 12:05:33 PM
 */
public class HashSummary implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1112389637275043740L;
	private static final String STRING_TOKEN = "::"; 
	private String hash;
	private String algorithm = null;
	private String providerName = null;
	private String providerInfo = null;
	private double providerVersion;
	
	public HashSummary(String hash, MessageDigest digest) {
		this.hash = hash;
		this.algorithm = digest.getAlgorithm();
		this.providerName = digest.getProvider().getName();
		this.providerInfo = digest.getProvider().getInfo();
		this.providerVersion = digest.getProvider().getVersion();
	}
	
	private HashSummary(String hash) {
		this.hash = hash;
	}	

	/**
	 * @return the hash
	 */
	public String getHash() {
		return hash;
	}

	/**
	 * @return the algorithm
	 */
	public String getAlgorithm() {
		return algorithm;
	}

	/**
	 * @return the providerName
	 */
	public String getProviderName() {
		return providerName;
	}

	/**
	 * @return the providerInfo
	 */
	public String getProviderInfo() {
		return providerInfo;
	}

	/**
	 * @return the providerVersion
	 */
	public double getProviderVersion() {
		return providerVersion;
	}
	
	public String getHashSummary() {
		return algorithm + STRING_TOKEN + providerName + STRING_TOKEN +
			providerVersion + STRING_TOKEN + hash;		
	}
	
	public String toString() {
		return getHashSummary();
	}
	
	public static HashSummary valueOf(String hashSummary) {
		if(StringUtils.isEmpty(hashSummary))
			return null;
		
		String[] tokens = hashSummary.split(STRING_TOKEN);
		HashSummary summary = new HashSummary(tokens[3]);
		summary.algorithm = tokens[0];
		summary.providerName = tokens[1];
		summary.providerVersion = Double.valueOf(tokens[2]);
		return summary;		
	}
}
