/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.model;

import gov.va.med.fw.service.AbstractComponent;

import java.io.Serializable;

/**
 * Factory for creating appropriate EntityKey implementations.
 * 
 * Created Jul 31, 2005 9:50:27 PM
 * 
 * @author DNS   BOHMEG
 */
public class EntityKeyFactory extends AbstractComponent {
	public static <T> EntityKey<T> createEntityKey(Serializable identifier, Class<T> targetClass) {
		return new BaseEntityKey<T>(identifier, targetClass);
	}

	public static <T> EntityKey<T> createEntityKey(Serializable identifier, Integer version,
			Class<T> targetClass) {
		return new BaseEntityKey<T>(identifier, version, targetClass);
	}
}
