/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model;

import java.io.Serializable;

/**
 * Common interface to represent an entity's key and provide stronger typing in
 * service calls around entity identification.
 * 
 * Created Jul 18, 2005 6:23:30 PM
 * 
 * @author DNS   BOHMEG
 */
public interface EntityKey<T> extends Serializable {

	/** Return the unique key value for this entity */
	public Serializable getKeyValue();

	/** Return the Class for the target entity */
	public Class<T> getEntityClass();

	/**
	 * Returns a key value in a string representation
	 * 
	 * @return A key value as string
	 */
	public String getKeyValueAsString();

	public String getSummary();
}
