/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model;

import gov.va.med.esr.model.ServiceUser;

import java.sql.Timestamp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Contains summary info about an audit event to an AbstractEntity.
 * 
 * Created Jan 24, 2007 1:58:37 PM
 * 
 * @author DNS   BOHMEG
 */
@XmlAccessorType(XmlAccessType.FIELD)
public class AuditInfo extends AbstractEntity {

	private static final long serialVersionUID = 8255942734754635024L;
	@XmlTransient
	private EntityKey entityKey;
	@XmlTransient
	private Timestamp changeDate;
	private String changeUser;
	private String status;

	public AuditInfo() {
		super();
	}

	public AuditInfo(String changeUser) {
		super();
		this.changeUser = changeUser;
	}

	public AuditInfo(ServiceUser userPrincipal) {
		super();
		if (userPrincipal != null && userPrincipal.getUserName() != null) {
			this.changeUser = userPrincipal.getUserName() ;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang
	 * .builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("entityKey", entityKey);
		builder.append("changeDate", changeDate);
		builder.append("changeUser", changeUser);
		builder.append("status", status);
	}

	/**
	 * @return Returns the changeDate.
	 */
	public Timestamp getChangeDate() {
		return changeDate;
	}

	/**
	 * @param changeDate
	 *            The changeDate to set.
	 */
	public void setChangeDate(Timestamp changeDate) {
		this.changeDate = changeDate;
	}

	/**
	 * @return Returns the changeUser.
	 */
	public String getChangeUser() {
		return changeUser;
	}

	/**
	 * @param changeUser
	 *            The changeUser to set.
	 */
	public void setChangeUser(String changeUser) {
		this.changeUser = changeUser;
	}

	/**
	 * @return Returns the status.
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status
	 *            The status to set.
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the entityKey
	 */
	public EntityKey getEntityKey() {
		return entityKey;
	}

	/**
	 * @param entityKey
	 *            the entityKey to set
	 */
	public void setEntityKey(EntityKey entityKey) {
		this.entityKey = entityKey;
	}
}
